/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.ifd.scio;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum SCIOProtocol {
    T0("T=0"),
    T1("T=1"),
    TCL("T=CL"),
    ANY("*");

    public final String identifier;

    private SCIOProtocol(String identifier) {
        this.identifier = identifier;
    }

    @Nonnull
    public static SCIOProtocol getType(@Nullable String protocol) {
        if (SCIOProtocol.T0.identifier.equals(protocol)) {
            return T0;
        }
        if (SCIOProtocol.T1.identifier.equals(protocol)) {
            return T1;
        }
        if (SCIOProtocol.TCL.identifier.equals(protocol)) {
            return TCL;
        }
        return ANY;
    }

    public String toString() {
        return this.identifier;
    }

    @Nullable
    public String toUri() {
        switch (this) {
            case T0: {
                return "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-0";
            }
            case T1: {
                return "urn:iso:std:iso-iec:7816:-3:tech:protocols:T-equals-1";
            }
            case TCL: {
                return "urn:iso:std:iso-iec:14443:-2:tech:protocols:Type-A";
            }
        }
        return null;
    }
}

