/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.event;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventRunner;
import org.openecard.common.event.EventType;
import org.openecard.common.event.EventTypeFilter;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.interfaces.EventFilter;
import org.openecard.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcherImpl
implements EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(EventDispatcherImpl.class);
    private static final long MAX_DISPATCH_MILLIS = 5000L;
    private final ConcurrentHashMap<EventCallback, ArrayList<EventFilter>> eventFilter = new ConcurrentHashMap();
    private final BlockingQueue<Pair<EventType, EventObject>> eventQueue = new LinkedBlockingQueue<Pair<EventType, EventObject>>();
    private ExecutorService threadPool;

    @Override
    public synchronized void start() {
        this.threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(0);
            private final ThreadGroup group = new ThreadGroup("Event Dispatcher");

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format("Dispatcher Event %d", this.num.getAndIncrement());
                Thread t = new Thread(this.group, r, name);
                t.setDaemon(false);
                return t;
            }
        });
        this.threadPool.submit(new NotificationSender());
    }

    @Override
    public synchronized void terminate() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    @Override
    public EventCallback add(EventCallback cb) {
        this.add(cb, new EventTypeFilter(new EventType[0]));
        return cb;
    }

    @Override
    public EventCallback add(EventCallback cb, EventType ... eventTypes) {
        this.add(cb, new EventTypeFilter(eventTypes));
        return cb;
    }

    @Override
    public synchronized EventCallback add(EventCallback cb, EventFilter filter) {
        if (!this.eventFilter.containsKey(cb)) {
            this.eventFilter.put(cb, new ArrayList());
        }
        this.eventFilter.get(cb).add(filter);
        return cb;
    }

    @Override
    public synchronized EventCallback del(EventCallback cb) {
        if (this.eventFilter.containsKey(cb)) {
            this.eventFilter.remove(cb);
        }
        return cb;
    }

    @Override
    public void notify(EventType t, EventObject o) {
        if (this.eventQueue.offer(new Pair<EventType, EventObject>(t, o))) {
            LOG.debug("Added event {} into event queue.", (Object)t);
        } else {
            LOG.error("Failed to add event {} into the queue, the queue is full.", (Object)t);
        }
    }

    private class NotificationSender
    implements Runnable {
        private NotificationSender() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Pair pair = (Pair)EventDispatcherImpl.this.eventQueue.take();
                    this.notify((EventType)((Object)pair.p1), (EventObject)pair.p2);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notify(EventType t, EventObject o) {
            EventDispatcherImpl eventDispatcherImpl = EventDispatcherImpl.this;
            synchronized (eventDispatcherImpl) {
                ArrayList futures = new ArrayList();
                block7: for (Map.Entry entry : EventDispatcherImpl.this.eventFilter.entrySet()) {
                    EventCallback cb = (EventCallback)entry.getKey();
                    for (EventFilter filter : (ArrayList)entry.getValue()) {
                        if (!filter.matches(t, o)) continue;
                        futures.add(this.fork(cb, t, o));
                        continue block7;
                    }
                }
                long remaining = 5000L;
                for (Future future : futures) {
                    if (remaining > 0L) {
                        long start = System.currentTimeMillis();
                        try {
                            future.get(remaining, TimeUnit.MILLISECONDS);
                        }
                        catch (ExecutionException executionException) {
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        catch (TimeoutException ex) {
                            remaining = -1L;
                            continue;
                        }
                        long diff = System.currentTimeMillis() - start;
                        remaining -= diff;
                        continue;
                    }
                    LOG.warn("Skipping wait for event notification thread.");
                }
            }
        }

        private Future<?> fork(EventCallback cb, EventType t, EventObject o) {
            Future<?> f = EventDispatcherImpl.this.threadPool.submit(new EventRunner(cb, t, o));
            return f;
        }
    }
}

