/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.util.ByteUtils;

public class SALErrorUtils {
    @Nonnull
    public static String getMajor(byte[] code) {
        if (code == null || code.length != 2) {
            throw new IllegalArgumentException("Given response code is not exactly two bytes long.");
        }
        String codeStr = ByteUtils.toHexString(code);
        if ("9000".equals(codeStr) || codeStr.startsWith("61")) {
            return "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok";
        }
        return "http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error";
    }

    @Nullable
    public static String getMinor(byte[] code) {
        if (code == null || code.length != 2) {
            throw new IllegalArgumentException("Given response code is not exactly two bytes long.");
        }
        String codeStr = ByteUtils.toHexString(code);
        String defaultError = "http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#unknownError";
        if ("9000".equals(codeStr) || codeStr.startsWith("61")) {
            return null;
        }
        if (codeStr.startsWith("69")) {
            if (codeStr.endsWith("82")) {
                return "http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#securityConditionNotSatisfied";
            }
            return defaultError;
        }
        return defaultError;
    }
}

