/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openecard.common.apdu.ReadBinary;
import org.openecard.common.apdu.ReadRecord;
import org.openecard.common.apdu.Select;
import org.openecard.common.apdu.UpdateRecord;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.common.TrailerConstants;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.DataElements;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ShortUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CardUtils.class);
    public static final int NO_RESPONSE_DATA = 0;
    public static final int FCP_RESPONSE_DATA = 1;
    public static final int FCI_RESPONSE_DATA = 2;
    public static final int FMD_RESPONSE_DATA = 3;

    public static void selectMF(Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        Select.MasterFile selectMF = new Select.MasterFile();
        selectMF.transmit(dispatcher, slotHandle);
    }

    public static CardResponseAPDU selectFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        return CardUtils.selectFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    public static CardResponseAPDU selectFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        return CardUtils.selectFileWithOptions(dispatcher, slotHandle, fileID, null, 0);
    }

    public static CardResponseAPDU selectFileWithOptions(Dispatcher dispatcher, byte[] slotHandle, byte[] fileIdOrPath, List<byte[]> responses, int resultType) throws APDUException {
        CardResponseAPDU result = null;
        int i = 0;
        while (i < fileIdOrPath.length) {
            Select selectFile;
            if (fileIdOrPath[i] == 63 && fileIdOrPath[i + 1] == 0 && i == 0 && i + 1 == 1) {
                selectFile = new Select.MasterFile();
                i += 2;
            } else if (i == fileIdOrPath.length - 2) {
                selectFile = new Select.ChildFile(new byte[]{fileIdOrPath[i], fileIdOrPath[i + 1]});
                switch (resultType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        selectFile.setFCP();
                        break;
                    }
                    case 2: {
                        selectFile.setFCI();
                        break;
                    }
                    case 3: {
                        selectFile.setFMD();
                        break;
                    }
                    default: {
                        throw new APDUException("There is no value assoziated with the returnType value " + resultType);
                    }
                }
                i += 2;
            } else {
                selectFile = new Select.ChildDirectory(new byte[]{fileIdOrPath[i], fileIdOrPath[i + 1]});
                i += 2;
            }
            if (responses == null) {
                if (i == 2 && fileIdOrPath[0] == 63 && fileIdOrPath[1] == 0) {
                    responses = new ArrayList<byte[]>();
                    responses.add(new byte[]{-112, 0});
                    responses.add(new byte[]{103, 0});
                    responses.add(new byte[]{106, -122});
                }
                if (Arrays.equals((result = selectFile.transmit(dispatcher, slotHandle, responses)).getTrailer(), new byte[]{-112, 0}) || i != 2 || fileIdOrPath[0] != 63 || fileIdOrPath[1] != 0) continue;
                selectFile = new Select(0, 12);
                result = selectFile.transmit(dispatcher, slotHandle, responses);
                if (Arrays.equals(result.getTrailer(), new byte[]{-112, 0}) || fileIdOrPath.length <= 2 || !Arrays.equals((result = (selectFile = new Select.AbsolutePath(fileIdOrPath)).transmit(dispatcher, slotHandle)).getTrailer(), TrailerConstants.Success.OK())) continue;
                return result;
            }
            result = selectFile.transmit(dispatcher, slotHandle, responses);
        }
        return result;
    }

    public static CardResponseAPDU selectApplicationByFID(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        CardResponseAPDU result = null;
        int i = 0;
        while (i < fileID.length) {
            Select selectApp;
            if (fileID[i] == 63 && fileID[i + 1] == 0 && i == 0 && i + 1 == 1) {
                selectApp = new Select.MasterFile();
                i += 2;
            } else {
                selectApp = new Select.ChildDirectory(new byte[]{fileID[i], fileID[i + 1]});
                selectApp.setLE((byte)-1);
                selectApp.setFCP();
                i += 2;
            }
            result = selectApp.transmit(dispatcher, slotHandle);
        }
        return result;
    }

    public static CardResponseAPDU selectApplicationByAID(Dispatcher dispatcher, byte[] slotHandle, byte[] aid) throws APDUException {
        Select selectApp = new Select(4, 4);
        selectApp.setData(aid);
        selectApp.setLE((byte)-1);
        CardResponseAPDU result = selectApp.transmit(dispatcher, slotHandle);
        return result;
    }

    public static byte[] readFile(FCP fcp, Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        boolean isRecord;
        Long fcpNumBytes;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte length = -1;
        int numToRead = -1;
        if (fcp != null && (fcpNumBytes = fcp.getNumBytes()) != null && (numToRead = (int)fcpNumBytes.shortValue()) < 255) {
            length = (byte)numToRead;
        }
        byte i = (byte)((isRecord = CardUtils.isRecordEF(fcp)) ? 1 : 0);
        short numRead = 0;
        try {
            boolean goAgain;
            int lastNumRead = 0;
            do {
                CardResponseAPDU response;
                if (!isRecord) {
                    ReadBinary readBinary = new ReadBinary(numRead, length);
                    response = readBinary.transmit(dispatcher, slotHandle, CardCommandStatus.response(36864, 25218, 27268, 27267, 27270, 27392));
                } else {
                    ReadRecord readRecord = new ReadRecord(i);
                    response = readRecord.transmit(dispatcher, slotHandle, CardCommandStatus.response(36864, 25218, 27268, 27267));
                }
                byte[] trailer = response.getTrailer();
                if (!(Arrays.equals(trailer, new byte[]{106, -124}) || Arrays.equals(trailer, new byte[]{106, -125}) || Arrays.equals(trailer, new byte[]{106, -122}))) {
                    byte[] data = response.getData();
                    baos.write(data);
                    lastNumRead = data.length;
                    numRead = (short)(numRead + lastNumRead);
                }
                i = (byte)(i + 1);
                boolean bl = goAgain = response.isNormalProcessed() && lastNumRead != 0 || Arrays.equals(trailer, new byte[]{98, -126}) && isRecord;
                if (!goAgain || numToRead == -1) continue;
                short remainingBytes = (short)(numToRead - numRead);
                if (remainingBytes <= 0) {
                    goAgain = false;
                    continue;
                }
                if (remainingBytes >= 255) continue;
                length = (byte)remainingBytes;
            } while (goAgain);
            baos.close();
        }
        catch (IOException e) {
            throw new APDUException(e);
        }
        return baos.toByteArray();
    }

    @Deprecated
    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        return CardUtils.readFile(dispatcher, slotHandle, ShortUtils.toByteArray(fileID));
    }

    @Deprecated
    public static byte[] readFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        CardResponseAPDU selectResponse = CardUtils.selectFileWithOptions(dispatcher, slotHandle, fileID, null, 1);
        FCP fcp = null;
        try {
            fcp = new FCP(selectResponse.getData());
        }
        catch (TLVException e) {
            LOG.warn("Couldn't get File Control Parameters from Select response.", e);
        }
        return CardUtils.readFile(fcp, dispatcher, slotHandle);
    }

    public static byte[] selectReadFile(Dispatcher dispatcher, byte[] slotHandle, short fileID) throws APDUException {
        return CardUtils.readFile(dispatcher, slotHandle, fileID);
    }

    public static byte[] selectReadFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID) throws APDUException {
        return CardUtils.readFile(dispatcher, slotHandle, fileID);
    }

    private static boolean isRecordEF(FCP fcp) {
        if (fcp == null) {
            return false;
        }
        DataElements dataElements = fcp.getDataElements();
        return dataElements.isLinear() || dataElements.isCyclic();
    }

    public static void writeFile(Dispatcher dispatcher, byte[] slotHandle, byte[] fileID, byte[] data) throws APDUException {
        CardResponseAPDU selectResponse = CardUtils.selectFile(dispatcher, slotHandle, fileID);
        FCP fcp = null;
        try {
            fcp = new FCP(selectResponse.getData());
        }
        catch (TLVException e) {
            LOG.warn("Couldn't get File Control Parameters from Select response.", e);
        }
        CardUtils.writeFile(fcp, dispatcher, slotHandle, data);
    }

    private static void writeFile(FCP fcp, Dispatcher dispatcher, byte[] slotHandle, byte[] data) throws APDUException {
        if (!CardUtils.isRecordEF(fcp)) {
            throw new UnsupportedOperationException("Not yet implemented.");
        }
        UpdateRecord updateRecord = new UpdateRecord(data);
        updateRecord.transmit(dispatcher, slotHandle);
    }
}

