/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import iso.std.iso_iec._24727.tech.schema.CardCallTemplateType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.apdu.common.APDUTemplateException;
import org.openecard.common.apdu.common.APDUTemplateFunction;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;

public class CardCommandTemplate {
    private static final Pattern EXPRESSION = Pattern.compile("\\{.*?\\}");
    private final CardCallTemplateType template;

    public CardCommandTemplate(@Nonnull CardCallTemplateType apduTemplate) {
        this.template = apduTemplate;
    }

    @Nonnull
    public CardCommandAPDU evaluate(@Nonnull Map<String, Object> context) throws APDUTemplateException {
        byte[] head = this.evalTemplate(this.template.getHeaderTemplate(), context);
        byte[] data = this.evalTemplate(this.template.getDataTemplate(), context);
        BigInteger length = this.template.getExpectedLength();
        if (head.length != 4) {
            throw new APDUTemplateException("The computed command APDU header is not valid.");
        }
        CardCommandAPDU apdu = new CardCommandAPDU();
        apdu.setCLA(head[0]);
        apdu.setINS(head[1]);
        apdu.setP1(head[2]);
        apdu.setP2(head[3]);
        if (data.length > 0) {
            apdu.setData(data);
        }
        if (length != null) {
            apdu.setLE(length.intValue());
        }
        return apdu;
    }

    @Nonnull
    private byte[] evalTemplate(@Nullable String s, @Nonnull Map<String, Object> context) throws APDUTemplateException {
        if (s == null) {
            return new byte[0];
        }
        Matcher m = EXPRESSION.matcher(s);
        while (m.find()) {
            String result;
            String expr = m.group();
            expr = expr.substring(1, expr.length() - 1);
            String[] tokens = this.getTokens(expr);
            Object firstObj = this.getFirstObject(tokens, context);
            if (tokens.length == 1) {
                result = this.evalObject(firstObj);
            } else {
                Object[] params = this.getParameters(tokens, context);
                result = this.evalObject(firstObj, params);
            }
            s = m.reset().replaceFirst(result);
            m.reset(s);
        }
        byte[] resultBytes = StringUtils.toByteArray(s, true);
        return resultBytes;
    }

    private String evalObject(Object o) throws APDUTemplateException {
        return this.evalObject(o, new Object[0]);
    }

    private String evalObject(@Nonnull Object o, @Nonnull Object[] params) throws APDUTemplateException {
        if (o instanceof byte[]) {
            String result = ByteUtils.toHexString((byte[])o);
            return result;
        }
        if (o instanceof APDUTemplateFunction) {
            APDUTemplateFunction fun = (APDUTemplateFunction)o;
            String result = fun.call(params);
            return result;
        }
        return o.toString();
    }

    @Nonnull
    private String[] getTokens(@Nonnull String expr) {
        String[] groups = expr.split("\\s+");
        return groups;
    }

    @Nonnull
    private Object getFirstObject(@Nonnull String[] tokens, @Nonnull Map<String, Object> ctx) throws APDUTemplateException {
        Object firstObj = ctx.get(tokens[0]);
        if (firstObj == null) {
            throw new NullPointerException();
        }
        if (tokens.length > 1 && !(firstObj instanceof APDUTemplateFunction)) {
            throw new APDUTemplateException("Multiple element template but no function named.");
        }
        return firstObj;
    }

    @Nonnull
    private Object[] getParameters(@Nonnull String[] tokens, @Nonnull Map<String, Object> context) throws APDUTemplateException {
        ArrayList<Object> result = new ArrayList<Object>(tokens.length - 1);
        for (int i = 1; i < tokens.length; ++i) {
            String next = tokens[i];
            if (next.startsWith("0x")) {
                String value = next.substring(2);
                result.add(value);
                continue;
            }
            Object o = context.get(next);
            if (o instanceof APDUTemplateFunction) {
                throw new APDUTemplateException("Function used in parameter list.");
            }
            result.add(o);
        }
        return result.toArray();
    }
}

