/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.openecard.common.util.IntegerUtils;

public final class CardAPDUOutputStream
extends ByteArrayOutputStream {
    public CardAPDUOutputStream() {
    }

    public CardAPDUOutputStream(int size) {
        super(size);
    }

    public void writeTLV(byte type, byte value) throws IOException {
        this.write(type);
        this.write(1);
        this.write(value);
    }

    public void writeTLV(byte type, byte[] value) throws IOException {
        int length = value.length;
        this.write(type);
        if (length > 127 && length <= 255) {
            this.write(-127);
        } else if (length == 255) {
            this.write(0);
        } else if (length > 255) {
            this.write(-126);
        }
        this.write(IntegerUtils.toByteArray(length));
        this.write(value);
    }
}

