/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import iso.std.iso_iec._24727.tech.schema.Transmit;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ShortUtils;

public class ReadRecord
extends CardCommandAPDU {
    private static final byte READ_RECORD_INS_1 = -78;
    private static final byte READ_RECORD_INS_2 = -77;

    public ReadRecord() {
        super((byte)0, (byte)-78, (byte)1, (byte)4, 255);
    }

    public ReadRecord(byte recordNumber) {
        super((byte)0, (byte)-78, recordNumber, (byte)4, 255);
    }

    public ReadRecord(byte shortFileID, byte recordNumber) {
        super((byte)0, (byte)-78, recordNumber, (byte)(shortFileID << 3 | 4), 255);
    }

    public ReadRecord(byte recordNumber, short offset, short length) {
        super((byte)0, (byte)-77, recordNumber, (byte)4);
        byte[] content = ShortUtils.toByteArray(offset);
        content = ByteUtils.concatenate((byte)84, content);
        this.setData(content);
        this.setLE(length);
    }

    public ReadRecord(byte shortFileID, byte recordNumber, short offset, short length) {
        super((byte)0, (byte)-77, recordNumber, (byte)(shortFileID << 3 | 4));
        byte[] content = ShortUtils.toByteArray(offset);
        content = ByteUtils.concatenate((byte)84, content);
        this.setData(content);
        this.setLE(length);
    }

    @Override
    public Transmit makeTransmit(byte[] slotHandle) {
        ArrayList<byte[]> defaultResponses = new ArrayList<byte[]>(){
            {
                this.add(new byte[]{-112, 0});
                this.add(new byte[]{98, -126});
            }
        };
        return this.makeTransmit(slotHandle, (List<byte[]>)defaultResponses);
    }
}

