/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import java.util.List;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;

public class EraseBinary
extends CardCommandAPDU {
    private static final byte WITH_OFFSET = 14;
    private static final byte WITH_OFFSET_DATA_OBJECT = 15;

    public EraseBinary(byte p1, byte p2, byte[] offset) {
        super((byte)0, (byte)14, p1, p2, offset);
    }

    public EraseBinary(byte p1, byte p2, List<TLV> offsetDataObjects) throws APDUException, TLVException {
        if (offsetDataObjects.size() > 2) {
            throw new APDUException("The maximum number of offset data objects for a ERASE BINARY command is 2.");
        }
        byte[] dataField = new byte[]{};
        for (TLV offSetObj : offsetDataObjects) {
            if (offSetObj.getTagNumWithClass() != 84L) {
                throw new APDUException("The offset data object does not start with tag 0x54");
            }
            dataField = ByteUtils.concatenate(dataField, offSetObj.toBER());
        }
        this.setINS((byte)15);
        this.setP1(p1);
        this.setP2(p2);
        this.setCLA((byte)0);
        this.setData(dataField);
        this.setLC(dataField.length);
    }
}

