/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.bc;

import org.openecard.bouncycastle.crypto.DSA;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.signers.DSADigestSigner;
import org.openecard.bouncycastle.tls.DigitallySigned;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public abstract class BcTlsDSSVerifier
extends BcTlsVerifier {
    protected BcTlsDSSVerifier(BcTlsCrypto crypto, AsymmetricKeyParameter publicKey) {
        super(crypto, publicKey);
    }

    protected abstract DSA createDSAImpl(short var1);

    protected abstract short getSignatureAlgorithm();

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        DSADigestSigner signer = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), this.crypto.createDigest((short)0));
        signer.init(false, this.publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(signedParams.getSignature());
    }
}

