/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.CryptoException;
import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.ExtendedDigest;
import org.openecard.bouncycastle.crypto.InvalidCipherTextException;
import org.openecard.bouncycastle.crypto.RuntimeCryptoException;
import org.openecard.bouncycastle.crypto.StreamCipher;
import org.openecard.bouncycastle.crypto.agreement.srp.SRP6Client;
import org.openecard.bouncycastle.crypto.agreement.srp.SRP6Server;
import org.openecard.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.openecard.bouncycastle.crypto.digests.MD5Digest;
import org.openecard.bouncycastle.crypto.digests.NullDigest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.digests.SHA224Digest;
import org.openecard.bouncycastle.crypto.digests.SHA256Digest;
import org.openecard.bouncycastle.crypto.digests.SHA384Digest;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.openecard.bouncycastle.crypto.engines.AESEngine;
import org.openecard.bouncycastle.crypto.engines.ARIAEngine;
import org.openecard.bouncycastle.crypto.engines.CamelliaEngine;
import org.openecard.bouncycastle.crypto.engines.DESedeEngine;
import org.openecard.bouncycastle.crypto.engines.RC4Engine;
import org.openecard.bouncycastle.crypto.engines.RSABlindedEngine;
import org.openecard.bouncycastle.crypto.engines.SEEDEngine;
import org.openecard.bouncycastle.crypto.macs.HMac;
import org.openecard.bouncycastle.crypto.modes.AEADBlockCipher;
import org.openecard.bouncycastle.crypto.modes.CBCBlockCipher;
import org.openecard.bouncycastle.crypto.modes.CCMBlockCipher;
import org.openecard.bouncycastle.crypto.modes.GCMBlockCipher;
import org.openecard.bouncycastle.crypto.modes.OCBBlockCipher;
import org.openecard.bouncycastle.crypto.params.AEADParameters;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.crypto.params.SRP6GroupParameters;
import org.openecard.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.openecard.bouncycastle.tls.HashAlgorithm;
import org.openecard.bouncycastle.tls.NamedGroup;
import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCipher;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.tls.crypto.TlsDHConfig;
import org.openecard.bouncycastle.tls.crypto.TlsDHDomain;
import org.openecard.bouncycastle.tls.crypto.TlsECConfig;
import org.openecard.bouncycastle.tls.crypto.TlsECDomain;
import org.openecard.bouncycastle.tls.crypto.TlsHMAC;
import org.openecard.bouncycastle.tls.crypto.TlsHash;
import org.openecard.bouncycastle.tls.crypto.TlsNonceGenerator;
import org.openecard.bouncycastle.tls.crypto.TlsSRP6Client;
import org.openecard.bouncycastle.tls.crypto.TlsSRP6Server;
import org.openecard.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import org.openecard.bouncycastle.tls.crypto.TlsSRPConfig;
import org.openecard.bouncycastle.tls.crypto.TlsSecret;
import org.openecard.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import org.openecard.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.openecard.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import org.openecard.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.openecard.bouncycastle.tls.crypto.impl.TlsEncryptor;
import org.openecard.bouncycastle.tls.crypto.impl.TlsNullCipher;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import org.openecard.bouncycastle.util.Arrays;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom entropySource;

    public BcTlsCrypto(SecureRandom entropySource) {
        this.entropySource = entropySource;
    }

    BcTlsSecret adoptLocalSecret(byte[] data) {
        return new BcTlsSecret(this, data);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.entropySource;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(cryptoParams, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(cryptoParams, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 103: {
                return this.createCipher_AES_OCB(cryptoParams, 16, 12);
            }
            case 9: {
                return this.createAESCipher(cryptoParams, 32, macAlgorithm);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 104: {
                return this.createCipher_AES_OCB(cryptoParams, 32, 12);
            }
            case 22: {
                return this.createARIACipher(cryptoParams, 16, macAlgorithm);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
            }
            case 23: {
                return this.createARIACipher(cryptoParams, 32, macAlgorithm);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(cryptoParams, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new BcTlsECDomain(this, ecConfig);
    }

    @Override
    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificate bcCert = BcTlsCertificate.convert(this, certificate);
        bcCert.validateKeyUsage(32);
        final RSAKeyParameters pubKeyRSA = bcCert.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
                    encoding.init(true, new ParametersWithRandom(pubKeyRSA, BcTlsCrypto.this.getSecureRandom()));
                    return encoding.processBlock(input, inOff, length);
                }
                catch (InvalidCipherTextException e) {
                    throw new TlsFatalAlert(80, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        final DigestRandomGenerator nonceGen = new DigestRandomGenerator(this.createDigest((short)4));
        if (additionalSeedMaterial != null && additionalSeedMaterial.length > 0) {
            nonceGen.addSeedMaterial(additionalSeedMaterial);
        }
        byte[] seed = new byte[this.createDigest((short)4).getDigestSize()];
        this.entropySource.nextBytes(seed);
        nonceGen.addSeedMaterial(seed);
        return new TlsNonceGenerator(){

            @Override
            public byte[] generateNonce(int size) {
                byte[] nonce = new byte[size];
                nonceGen.nextBytes(nonce);
                return nonce;
            }
        };
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return true;
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    @Override
    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.adoptLocalSecret(Arrays.clone(data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] data = new byte[48];
        this.entropySource.nextBytes(data);
        TlsUtils.writeVersion(version, data, 0);
        return this.adoptLocalSecret(data);
    }

    public Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 0: {
                return new NullDigest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    @Override
    public TlsHash createHash(short algorithm) {
        return new BcTlsHash(algorithm, this.createDigest(algorithm));
    }

    public static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createAESBlockCipher(), true), new BlockOperator(this.createAESBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createARIACipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createARIABlockCipher(), true), new BlockOperator(this.createARIABlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createCamelliaBlockCipher(), true), new BlockOperator(this.createCamelliaBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new TlsAEADCipher(cryptoParams, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_CCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_CCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_GCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_OCB(), true), new AeadOperator(this.createAEADBlockCipher_AES_OCB(), false), cipherKeySize, macSize, 2);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), true), new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), true), new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createDESedeBlockCipher(), true), new BlockOperator(this.createDESedeBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm));
    }

    protected TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new BlockOperator(this.createSEEDBlockCipher(), true), new BlockOperator(this.createSEEDBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected BlockCipher createARIABlockCipher() {
        return new CBCBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_OCB() {
        return new OCBBlockCipher(this.createAESEngine(), this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return new GCMBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        return new HMacOperator(this.createDigest(TlsUtils.getHashAlgorithmForHMACAlgorithm(macAlgorithm)));
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client srpClient = new SRP6Client();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpClient.init(srpGroup, new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return srpClient.calculateSecret(serverB);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return srpClient.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server srpServer = new SRP6Server();
        BigInteger[] ng = srpConfig.getExplicitNG();
        SRP6GroupParameters srpGroup = new SRP6GroupParameters(ng[0], ng[1]);
        srpServer.init(srpGroup, srpVerifier, new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return srpServer.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return srpServer.calculateSecret(clientA);
                }
                catch (CryptoException e) {
                    throw new TlsFatalAlert(47, (Throwable)e);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] ng = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(ng[0], ng[1], new SHA1Digest());
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return verifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    private class HMacOperator
    implements TlsHMAC {
        private final HMac hmac;

        HMacOperator(Digest digest) {
            this.hmac = new HMac(digest);
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.hmac.init(new KeyParameter(key, keyOff, keyLen));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.hmac.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] rv = new byte[this.hmac.getMacSize()];
            this.hmac.doFinal(rv, 0);
            return rv;
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.hmac.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.hmac.getMacSize();
        }

        @Override
        public void reset() {
            this.hmac.reset();
        }
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean isEncrypting;
        private final AEADBlockCipher cipher;
        private KeyParameter key;

        public AeadOperator(AEADBlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
        }

        @Override
        public void init(byte[] nonce, int macSize, byte[] additionalData) {
            this.cipher.init(this.isEncrypting, new AEADParameters(this.key, macSize * 8, nonce, additionalData));
        }

        @Override
        public int getOutputSize(int inputLength) {
            return this.cipher.getOutputSize(inputLength);
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int len = this.cipher.processBytes(input, inputOffset, inputLength, output, outputOffset);
            try {
                return len + this.cipher.doFinal(output, outputOffset + len);
            }
            catch (InvalidCipherTextException e) {
                throw new RuntimeCryptoException(e.toString());
            }
        }
    }

    private class BlockOperator
    implements TlsBlockCipherImpl {
        private final boolean isEncrypting;
        private final BlockCipher cipher;
        private KeyParameter key;

        BlockOperator(BlockCipher cipher, boolean isEncrypting) {
            this.cipher = cipher;
            this.isEncrypting = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.key = new KeyParameter(key, keyOff, keyLen);
            this.cipher.init(this.isEncrypting, new ParametersWithIV(this.key, new byte[this.cipher.getBlockSize()]));
        }

        @Override
        public void init(byte[] iv, int ivOff, int ivLen) {
            this.cipher.init(this.isEncrypting, new ParametersWithIV(null, iv, ivOff, ivLen));
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int blockSize = this.cipher.getBlockSize();
            for (int i = 0; i < inputLength; i += blockSize) {
                this.cipher.processBlock(input, inputOffset + i, output, outputOffset + i);
            }
            return inputLength;
        }

        @Override
        public int getBlockSize() {
            return this.cipher.getBlockSize();
        }
    }

    private static class BcTlsHash
    implements TlsHash {
        private final short hashAlgorithm;
        private final Digest digest;

        BcTlsHash(short hashAlgorithm, Digest digest) {
            this.hashAlgorithm = hashAlgorithm;
            this.digest = digest;
        }

        @Override
        public void update(byte[] data, int offSet, int length) {
            this.digest.update(data, offSet, length);
        }

        @Override
        public byte[] calculateHash() {
            byte[] rv = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(rv, 0);
            return rv;
        }

        @Override
        public Object clone() {
            return new BcTlsHash(this.hashAlgorithm, BcTlsCrypto.cloneDigest(this.hashAlgorithm, this.digest));
        }

        @Override
        public void reset() {
            this.digest.reset();
        }
    }
}

