/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl;

import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.SecurityParameters;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.tls.crypto.TlsSecret;
import org.openecard.bouncycastle.util.Arrays;

public class TlsImplUtils {
    public static boolean isTLSv11(ProtocolVersion version) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsCryptoParameters cryptoParams) {
        return TlsImplUtils.isTLSv11(cryptoParams.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion version) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(version.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsCryptoParameters cryptoParams) {
        return TlsImplUtils.isTLSv12(cryptoParams.getServerVersion());
    }

    public static byte[] calculateKeyBlock(TlsCryptoParameters cryptoParams, int length) {
        SecurityParameters securityParameters = cryptoParams.getSecurityParameters();
        TlsSecret master_secret = securityParameters.getMasterSecret();
        byte[] seed = Arrays.concatenate(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        return TlsImplUtils.PRF(cryptoParams, master_secret, "key expansion", seed, length).extract();
    }

    public static TlsSecret PRF(TlsCryptoParameters cryptoParams, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        int prfAlgorithm = cryptoParams.getSecurityParameters().getPrfAlgorithm();
        return secret.deriveUsingPRF(prfAlgorithm, asciiLabel, seed, length);
    }
}

