/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import java.util.Vector;
import org.openecard.bouncycastle.tls.AbstractTlsKeyExchangeFactory;
import org.openecard.bouncycastle.tls.TlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.TlsDHEKeyExchange;
import org.openecard.bouncycastle.tls.TlsDHKeyExchange;
import org.openecard.bouncycastle.tls.TlsECConfigVerifier;
import org.openecard.bouncycastle.tls.TlsECDHEKeyExchange;
import org.openecard.bouncycastle.tls.TlsECDHKeyExchange;
import org.openecard.bouncycastle.tls.TlsKeyExchange;
import org.openecard.bouncycastle.tls.TlsPSKIdentity;
import org.openecard.bouncycastle.tls.TlsPSKIdentityManager;
import org.openecard.bouncycastle.tls.TlsPSKKeyExchange;
import org.openecard.bouncycastle.tls.TlsRSAKeyExchange;
import org.openecard.bouncycastle.tls.TlsSRPConfigVerifier;
import org.openecard.bouncycastle.tls.TlsSRPKeyExchange;
import org.openecard.bouncycastle.tls.TlsSRPLoginParameters;
import org.openecard.bouncycastle.tls.crypto.TlsDHConfig;
import org.openecard.bouncycastle.tls.crypto.TlsECConfig;

public class DefaultTlsKeyExchangeFactory
extends AbstractTlsKeyExchangeFactory {
    @Override
    public TlsKeyExchange createDHKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier) throws IOException {
        return new TlsDHKeyExchange(keyExchange, supportedSignatureAlgorithms, dhConfigVerifier);
    }

    @Override
    public TlsKeyExchange createDHKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHKeyExchange(keyExchange, supportedSignatureAlgorithms, dhConfig);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, supportedSignatureAlgorithms, dhConfigVerifier);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, supportedSignatureAlgorithms, dhConfig);
    }

    @Override
    public TlsKeyExchange createECDHKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) throws IOException {
        return new TlsECDHKeyExchange(keyExchange, supportedSignatureAlgorithms, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createECDHKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) throws IOException {
        return new TlsECDHKeyExchange(keyExchange, supportedSignatureAlgorithms, ecConfig, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange, supportedSignatureAlgorithms, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange, supportedSignatureAlgorithms, ecConfig, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, supportedSignatureAlgorithms, pskIdentity, dhConfigVerifier, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig, short[] serverECPointFormats) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, supportedSignatureAlgorithms, null, pskIdentityManager, dhConfig, ecConfig, serverECPointFormats);
    }

    @Override
    public TlsKeyExchange createRSAKeyExchange(Vector supportedSignatureAlgorithms) throws IOException {
        return new TlsRSAKeyExchange(supportedSignatureAlgorithms);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeClient(int keyExchange, Vector supportedSignatureAlgorithms, TlsSRPConfigVerifier srpConfigVerifier, byte[] identity, byte[] password) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, supportedSignatureAlgorithms, srpConfigVerifier, identity, password);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeServer(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, TlsSRPLoginParameters loginParameters) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, supportedSignatureAlgorithms, identity, loginParameters);
    }
}

