/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pqc.crypto.sphincs;

import org.openecard.bouncycastle.crypto.engines.ChaChaEngine;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.pqc.crypto.sphincs.HashFunctions;
import org.openecard.bouncycastle.pqc.crypto.sphincs.Tree;
import org.openecard.bouncycastle.util.Pack;

class Seed {
    Seed() {
    }

    static void get_seed(HashFunctions hs, byte[] seed, int seedOff, byte[] sk, Tree.leafaddr a) {
        byte[] buffer = new byte[40];
        for (int i = 0; i < 32; ++i) {
            buffer[i] = sk[i];
        }
        long t = a.level;
        t |= a.subtree << 4;
        Pack.longToLittleEndian(t |= a.subleaf << 59, buffer, 32);
        hs.varlen_hash(seed, seedOff, buffer, buffer.length);
    }

    static void prg(byte[] r, int rOff, long rlen, byte[] key, int keyOff) {
        byte[] nonce = new byte[8];
        ChaChaEngine cipher = new ChaChaEngine(12);
        cipher.init(true, new ParametersWithIV(new KeyParameter(key, keyOff, 32), nonce));
        cipher.processBytes(r, rOff, (int)rlen, r, rOff);
    }
}

