/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pkcs.bc;

import java.io.InputStream;
import org.openecard.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.ExtendedDigest;
import org.openecard.bouncycastle.crypto.digests.SHA1Digest;
import org.openecard.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.openecard.bouncycastle.crypto.io.CipherInputStream;
import org.openecard.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.openecard.bouncycastle.operator.GenericKey;
import org.openecard.bouncycastle.operator.InputDecryptor;
import org.openecard.bouncycastle.operator.InputDecryptorProvider;
import org.openecard.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

