/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pkcs;

import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1Sequence;
import org.openecard.bouncycastle.asn1.cms.ContentInfo;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.SafeBag;
import org.openecard.bouncycastle.cms.CMSEncryptedData;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.operator.InputDecryptorProvider;
import org.openecard.bouncycastle.pkcs.PKCS12SafeBag;
import org.openecard.bouncycastle.pkcs.PKCSException;

public class PKCS12SafeBagFactory {
    private ASN1Sequence safeBagSeq;

    public PKCS12SafeBagFactory(org.openecard.bouncycastle.asn1.pkcs.ContentInfo info) {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
        }
        this.safeBagSeq = ASN1Sequence.getInstance(ASN1OctetString.getInstance(info.getContent()).getOctets());
    }

    public PKCS12SafeBagFactory(org.openecard.bouncycastle.asn1.pkcs.ContentInfo info, InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        if (info.getContentType().equals(PKCSObjectIdentifiers.encryptedData)) {
            CMSEncryptedData encData = new CMSEncryptedData(ContentInfo.getInstance(info));
            try {
                this.safeBagSeq = ASN1Sequence.getInstance(encData.getContent(inputDecryptorProvider));
            }
            catch (CMSException e) {
                throw new PKCSException("unable to extract data: " + e.getMessage(), e);
            }
            return;
        }
        throw new IllegalArgumentException("encryptedData requires constructor with decryptor.");
    }

    public PKCS12SafeBag[] getSafeBags() {
        PKCS12SafeBag[] safeBags = new PKCS12SafeBag[this.safeBagSeq.size()];
        for (int i = 0; i != this.safeBagSeq.size(); ++i) {
            safeBags[i] = new PKCS12SafeBag(SafeBag.getInstance(this.safeBagSeq.getObjectAt(i)));
        }
        return safeBags;
    }
}

