/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.operator.jcajce;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.DERNull;
import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.openecard.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.openecard.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.openecard.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.openecard.bouncycastle.operator.AsymmetricKeyWrapper;
import org.openecard.bouncycastle.operator.GenericKey;
import org.openecard.bouncycastle.operator.OperatorException;
import org.openecard.bouncycastle.operator.jcajce.OperatorHelper;
import org.openecard.bouncycastle.operator.jcajce.OperatorUtils;

public class JceAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private Map extraMappings = new HashMap();
    private PublicKey publicKey;
    private SecureRandom random;
    private static final Map digests = new HashMap();

    public JceAsymmetricKeyWrapper(PublicKey publicKey) {
        super(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()).getAlgorithm());
        this.publicKey = publicKey;
    }

    public JceAsymmetricKeyWrapper(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    public JceAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, PublicKey publicKey) {
        super(algorithmIdentifier);
        this.publicKey = publicKey;
    }

    public JceAsymmetricKeyWrapper(AlgorithmParameterSpec algorithmParameterSpec, PublicKey publicKey) {
        super(JceAsymmetricKeyWrapper.extractFromSpec(algorithmParameterSpec));
        this.publicKey = publicKey;
    }

    public JceAsymmetricKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyWrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceAsymmetricKeyWrapper setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        this.extraMappings.put(algorithm, algorithmName);
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        Cipher keyEncryptionCipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), this.extraMappings);
        AlgorithmParameters algParams = this.helper.createAlgorithmParameters(this.getAlgorithmIdentifier());
        byte[] encryptedKeyBytes = null;
        try {
            if (algParams != null) {
                keyEncryptionCipher.init(3, (Key)this.publicKey, algParams, this.random);
            } else {
                keyEncryptionCipher.init(3, (Key)this.publicKey, this.random);
            }
            encryptedKeyBytes = keyEncryptionCipher.wrap(OperatorUtils.getJceKey(encryptionKey));
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        if (encryptedKeyBytes == null) {
            try {
                keyEncryptionCipher.init(1, (Key)this.publicKey, this.random);
                encryptedKeyBytes = keyEncryptionCipher.doFinal(OperatorUtils.getJceKey(encryptionKey).getEncoded());
            }
            catch (InvalidKeyException e) {
                throw new OperatorException("unable to encrypt contents key", e);
            }
            catch (GeneralSecurityException e) {
                throw new OperatorException("unable to encrypt contents key", e);
            }
        }
        return encryptedKeyBytes;
    }

    private static AlgorithmIdentifier extractFromSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof OAEPParameterSpec) {
            OAEPParameterSpec oaepSpec = (OAEPParameterSpec)algorithmParameterSpec;
            if (oaepSpec.getMGFAlgorithm().equals(OAEPParameterSpec.DEFAULT.getMGFAlgorithm())) {
                if (oaepSpec.getPSource() instanceof PSource.PSpecified) {
                    return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, new RSAESOAEPparams(JceAsymmetricKeyWrapper.getDigest(oaepSpec.getDigestAlgorithm()), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, JceAsymmetricKeyWrapper.getDigest(((MGF1ParameterSpec)oaepSpec.getMGFParameters()).getDigestAlgorithm())), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, new DEROctetString(((PSource.PSpecified)oaepSpec.getPSource()).getValue()))));
                }
                throw new IllegalArgumentException("unknown PSource: " + oaepSpec.getPSource().getAlgorithm());
            }
            throw new IllegalArgumentException("unknown MGF: " + oaepSpec.getMGFAlgorithm());
        }
        throw new IllegalArgumentException("unknown spec: " + algorithmParameterSpec.getClass().getName());
    }

    private static AlgorithmIdentifier getDigest(String digest) {
        AlgorithmIdentifier algId = (AlgorithmIdentifier)digests.get(digest);
        if (algId != null) {
            return algId;
        }
        throw new IllegalArgumentException("unknown digest name: " + digest);
    }

    static {
        digests.put("SHA-1", new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE));
        digests.put("SHA-1", new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, DERNull.INSTANCE));
        digests.put("SHA224", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE));
        digests.put("SHA-224", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, DERNull.INSTANCE));
        digests.put("SHA256", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE));
        digests.put("SHA-256", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, DERNull.INSTANCE));
        digests.put("SHA384", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE));
        digests.put("SHA-384", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, DERNull.INSTANCE));
        digests.put("SHA512", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE));
        digests.put("SHA-512", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, DERNull.INSTANCE));
        digests.put("SHA512/224", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_224, DERNull.INSTANCE));
        digests.put("SHA-512/224", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_224, DERNull.INSTANCE));
        digests.put("SHA-512(224)", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_224, DERNull.INSTANCE));
        digests.put("SHA512/256", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_256, DERNull.INSTANCE));
        digests.put("SHA-512/256", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_256, DERNull.INSTANCE));
        digests.put("SHA-512(256)", new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512_256, DERNull.INSTANCE));
    }
}

