/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.operator.bc;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.crypto.ExtendedDigest;
import org.openecard.bouncycastle.crypto.Signer;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.signers.DSADigestSigner;
import org.openecard.bouncycastle.crypto.signers.ECDSASigner;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;
import org.openecard.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.openecard.bouncycastle.operator.OperatorCreationException;
import org.openecard.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSADigestSigner(new ECDSASigner(), dig);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

