/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.openecard.bouncycastle.jsse.BCSSLConnection;
import org.openecard.bouncycastle.jsse.provider.ContextData;
import org.openecard.bouncycastle.jsse.provider.ProvSSLConnection;
import org.openecard.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.openecard.bouncycastle.jsse.provider.ProvSSLParameters;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSession;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.openecard.bouncycastle.jsse.provider.ProvTlsClient;
import org.openecard.bouncycastle.jsse.provider.ProvTlsManager;
import org.openecard.bouncycastle.jsse.provider.ProvTlsPeer;
import org.openecard.bouncycastle.jsse.provider.ProvTlsServer;
import org.openecard.bouncycastle.jsse.provider.SSLParametersUtil;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.TlsProtocol;
import org.openecard.bouncycastle.tls.TlsServerProtocol;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final String wrapHost;
    protected final int wrapPort;
    protected final boolean wrapAutoClose;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLSocketWrap(ProvSSLContextSpi context, ContextData contextData, Socket s, String host, int port, boolean autoClose) {
        this.context = context;
        this.contextData = contextData;
        this.wrapSocket = s;
        this.wrapHost = host;
        this.wrapPort = port;
        this.wrapAutoClose = autoClose;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol != null) {
            this.protocol.close();
        }
        if (this.wrapAutoClose) {
            this.wrapSocket.close();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    @Override
    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public int getPort() {
        return this.wrapSocket.getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    @Override
    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSession.NULL_SESSION : connection.getSession();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.wrapSocket.setKeepAlive(on);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.wrapSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.wrapSocket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.wrapSocket.setSendBufferSize(size);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.wrapSocket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.wrapSocket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.wrapSocket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.wrapSocket.setTrafficClass(tc);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.initialHandshakeBegun && mode != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        }
        finally {
            this.handshakeSession = null;
        }
    }

    @Override
    public String toString() {
        return this.wrapSocket.toString();
    }

    @Override
    public String getPeerHost() {
        return this.wrapHost;
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary() throws IOException {
        if (!this.initialHandshakeBegun) {
            this.startHandshake();
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                if (ProvSSLSocketWrap.this.protocol != null) {
                    ProvSSLSocketWrap.this.protocol.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketWrap.this.protocol.writeApplicationData(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary();
                ProvSSLSocketWrap.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketWrap.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            return ProvSSLSocketWrap.this.protocol.readApplicationData(b, off, len);
        }
    }
}

