/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.openecard.bouncycastle.jsse.provider.JsseUtils;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.openecard.bouncycastle.jsse.provider.SessionBindingListenerAdapter;
import org.openecard.bouncycastle.tls.SessionParameters;
import org.openecard.bouncycastle.tls.TlsSession;
import org.openecard.bouncycastle.util.Arrays;

class ProvSSLSession
implements SSLSession {
    protected static final ProvSSLSession NULL_SESSION = new ProvSSLSession(null, null);
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;

    ProvSSLSession(ProvSSLSessionContext sslSessionContext, TlsSession tlsSession) {
        this.sslSessionContext = sslSessionContext;
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    @Override
    public String getCipherSuite() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getCipherSuiteString(this.sessionParameters.getCipherSuite());
    }

    @Override
    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getId() {
        return this.tlsSession == null ? null : Arrays.clone(this.tlsSession.getSessionID());
    }

    @Override
    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate())) != null && chain.length > 0) {
            return chain;
        }
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.sessionParameters == null ? null : JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getLocalCertificate());
    }

    @Override
    public int getPacketBufferSize() {
        return 18437;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] chain;
        if (this.sessionParameters != null && (chain = JsseUtils.getX509CertificateChain(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null && chain.length > 0) {
            return chain;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getPeerHost() {
        return null;
    }

    @Override
    public int getPeerPort() {
        return -1;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal principal;
        if (this.sessionParameters != null && (principal = JsseUtils.getSubject(this.sslSessionContext.getCrypto(), this.sessionParameters.getPeerCertificate())) != null) {
            return principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    @Override
    public String getProtocol() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getProtocolString(this.sessionParameters.getNegotiatedVersion());
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    @Override
    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    @Override
    public void invalidate() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
    }

    @Override
    public boolean isValid() {
        return this.tlsSession != null && this.tlsSession.isResumable();
    }

    @Override
    public void putValue(String name, Object value) {
        this.notifyUnbound(name, this.valueMap.put(name, value));
        this.notifyBound(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.notifyUnbound(name, this.valueMap.remove(name));
    }

    protected void notifyBound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
    }

    protected void notifyUnbound(String name, Object value) {
        if (value instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }
}

