/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.symmetric;

import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.CipherKeyGenerator;
import org.openecard.bouncycastle.crypto.engines.CAST6Engine;
import org.openecard.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.openecard.bouncycastle.crypto.macs.GMac;
import org.openecard.bouncycastle.crypto.modes.GCMBlockCipher;
import org.openecard.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;

public final class CAST6 {
    private CAST6() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = CAST6.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CAST6", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.CAST6", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "CAST6", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "CAST6", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-CAST6", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.openecard.bouncycastle.crypto.macs.Poly1305(new CAST6Engine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new CAST6Engine();
                }
            });
        }
    }
}

