/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.keystore.bcfks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.ASN1InputStream;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.DERNull;
import org.openecard.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import org.openecard.bouncycastle.asn1.bc.EncryptedPrivateKeyData;
import org.openecard.bouncycastle.asn1.bc.EncryptedSecretKeyData;
import org.openecard.bouncycastle.asn1.bc.ObjectData;
import org.openecard.bouncycastle.asn1.bc.ObjectDataSequence;
import org.openecard.bouncycastle.asn1.bc.ObjectStore;
import org.openecard.bouncycastle.asn1.bc.ObjectStoreData;
import org.openecard.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;
import org.openecard.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import org.openecard.bouncycastle.asn1.bc.SecretKeyData;
import org.openecard.bouncycastle.asn1.cms.CCMParameters;
import org.openecard.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.openecard.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.openecard.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.openecard.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.openecard.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.openecard.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.openecard.bouncycastle.crypto.PBEParametersGenerator;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Strings;

class BcFKSKeyStoreSpi
extends KeyStoreSpi {
    private static final Map<String, ASN1ObjectIdentifier> oidMap = new HashMap<String, ASN1ObjectIdentifier>();
    private static final Map<ASN1ObjectIdentifier, String> publicAlgMap = new HashMap<ASN1ObjectIdentifier, String>();
    private static final BigInteger CERTIFICATE;
    private static final BigInteger PRIVATE_KEY;
    private static final BigInteger SECRET_KEY;
    private static final BigInteger PROTECTED_PRIVATE_KEY;
    private static final BigInteger PROTECTED_SECRET_KEY;
    private final BouncyCastleProvider provider;
    private final Map<String, ObjectData> entries = new HashMap<String, ObjectData>();
    private final Map<String, PrivateKey> privateKeyCache = new HashMap<String, PrivateKey>();
    private AlgorithmIdentifier hmacAlgorithm;
    private KeyDerivationFunc hmacPkbdAlgorithm;
    private Date creationDate;
    private Date lastModifiedDate;

    private static String getPublicKeyAlg(ASN1ObjectIdentifier oid) {
        String algName = publicAlgMap.get(oid);
        if (algName != null) {
            return algName;
        }
        return oid.getId();
    }

    BcFKSKeyStoreSpi(BouncyCastleProvider provider) {
        this.provider = provider;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        ObjectData ent = this.entries.get(alias);
        if (ent != null) {
            if (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY)) {
                PrivateKey cachedKey = this.privateKeyCache.get(alias);
                if (cachedKey != null) {
                    return cachedKey;
                }
                EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                EncryptedPrivateKeyInfo encInfo = EncryptedPrivateKeyInfo.getInstance(encPrivData.getEncryptedPrivateKeyInfo());
                try {
                    PrivateKeyInfo pInfo = PrivateKeyInfo.getInstance(this.decryptData("PRIVATE_KEY_ENCRYPTION", encInfo.getEncryptionAlgorithm(), password, encInfo.getEncryptedData()));
                    KeyFactory kFact = this.provider != null ? KeyFactory.getInstance(pInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.provider) : KeyFactory.getInstance(BcFKSKeyStoreSpi.getPublicKeyAlg(pInfo.getPrivateKeyAlgorithm().getAlgorithm()));
                    PrivateKey privateKey = kFact.generatePrivate(new PKCS8EncodedKeySpec(pInfo.getEncoded()));
                    this.privateKeyCache.put(alias, privateKey);
                    return privateKey;
                }
                catch (Exception e) {
                    throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover private key (" + alias + "): " + e.getMessage());
                }
            }
            if (ent.getType().equals(SECRET_KEY) || ent.getType().equals(PROTECTED_SECRET_KEY)) {
                EncryptedSecretKeyData encKeyData = EncryptedSecretKeyData.getInstance(ent.getData());
                try {
                    SecretKeyData keyData = SecretKeyData.getInstance(this.decryptData("SECRET_KEY_ENCRYPTION", encKeyData.getKeyEncryptionAlgorithm(), password, encKeyData.getEncryptedKeyData()));
                    SecretKeyFactory kFact = this.provider != null ? SecretKeyFactory.getInstance(keyData.getKeyAlgorithm().getId(), this.provider) : SecretKeyFactory.getInstance(keyData.getKeyAlgorithm().getId());
                    return kFact.generateSecret(new SecretKeySpec(keyData.getKeyBytes(), keyData.getKeyAlgorithm().getId()));
                }
                catch (Exception e) {
                    throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + alias + "): " + e.getMessage());
                }
            }
            throw new UnrecoverableKeyException("BCFKS KeyStore unable to recover secret key (" + alias + "): type not recognized");
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        ObjectData ent = this.entries.get(alias);
        if (ent != null && (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY))) {
            EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
            org.openecard.bouncycastle.asn1.x509.Certificate[] certificates = encPrivData.getCertificateChain();
            Certificate[] chain = new X509Certificate[certificates.length];
            for (int i = 0; i != chain.length; ++i) {
                chain[i] = this.decodeCertificate(certificates[i]);
            }
            return chain;
        }
        return null;
    }

    @Override
    public Certificate engineGetCertificate(String s) {
        ObjectData ent = this.entries.get(s);
        if (ent != null) {
            if (ent.getType().equals(PRIVATE_KEY) || ent.getType().equals(PROTECTED_PRIVATE_KEY)) {
                EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                org.openecard.bouncycastle.asn1.x509.Certificate[] certificates = encPrivData.getCertificateChain();
                return this.decodeCertificate(certificates[0]);
            }
            if (ent.getType().equals(CERTIFICATE)) {
                return this.decodeCertificate(ent.getData());
            }
        }
        return null;
    }

    private Certificate decodeCertificate(Object cert) {
        if (this.provider != null) {
            try {
                CertificateFactory certFact = CertificateFactory.getInstance("X.509", this.provider);
                return certFact.generateCertificate(new ByteArrayInputStream(org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(cert).getEncoded()));
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            return certFact.generateCertificate(new ByteArrayInputStream(org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(cert).getEncoded()));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date engineGetCreationDate(String s) {
        ObjectData ent = this.entries.get(s);
        if (ent != null) {
            try {
                return ent.getLastModifiedDate().getDate();
            }
            catch (ParseException e) {
                return new Date();
            }
        }
        return null;
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        Date creationDate;
        Date lastEditDate = creationDate = new Date();
        ObjectData entry = this.entries.get(alias);
        if (entry != null) {
            creationDate = this.extractCreationDate(entry, creationDate);
        }
        this.privateKeyCache.remove(alias);
        if (key instanceof PrivateKey) {
            if (chain == null) {
                throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
            }
            try {
                byte[] encodedKey = key.getEncoded();
                KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(32);
                byte[] keyBytes = this.generateKey(pbkdAlgId, "PRIVATE_KEY_ENCRYPTION", password != null ? password : new char[]{});
                Cipher c = this.provider == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.provider);
                c.init(1, new SecretKeySpec(keyBytes, "AES"));
                byte[] encryptedKey = c.doFinal(encodedKey);
                AlgorithmParameters algParams = c.getParameters();
                PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(algParams.getEncoded())));
                EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), encryptedKey);
                EncryptedPrivateKeyData keySeq = this.createPrivateKeySequence(keyInfo, chain);
                this.entries.put(alias, new ObjectData(PRIVATE_KEY, alias, creationDate, lastEditDate, keySeq.getEncoded(), null));
            }
            catch (Exception e) {
                throw new ExtKeyStoreException("BCFKS KeyStore exception storing private key: " + e.toString(), e);
            }
        } else if (key instanceof SecretKey) {
            if (chain != null) {
                throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
            }
            try {
                byte[] encryptedKey;
                byte[] encodedKey = key.getEncoded();
                KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(32);
                byte[] keyBytes = this.generateKey(pbkdAlgId, "SECRET_KEY_ENCRYPTION", password != null ? password : new char[]{});
                Cipher c = this.provider == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.provider);
                c.init(1, new SecretKeySpec(keyBytes, "AES"));
                String keyAlg = Strings.toUpperCase(key.getAlgorithm());
                if (keyAlg.indexOf("AES") > -1) {
                    encryptedKey = c.doFinal(new SecretKeyData(NISTObjectIdentifiers.aes, encodedKey).getEncoded());
                } else {
                    ASN1ObjectIdentifier algOid = oidMap.get(keyAlg);
                    if (algOid != null) {
                        encryptedKey = c.doFinal(new SecretKeyData(algOid, encodedKey).getEncoded());
                    } else {
                        throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + keyAlg + ") for storage.");
                    }
                }
                AlgorithmParameters algParams = c.getParameters();
                PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(algParams.getEncoded())));
                EncryptedSecretKeyData keyData = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), encryptedKey);
                this.entries.put(alias, new ObjectData(SECRET_KEY, alias, creationDate, lastEditDate, keyData.getEncoded(), null));
            }
            catch (Exception e) {
                throw new ExtKeyStoreException("BCFKS KeyStore exception storing private key: " + e.toString(), e);
            }
        } else {
            throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
        }
        this.lastModifiedDate = lastEditDate;
    }

    private SecureRandom getDefaultSecureRandom() {
        return new SecureRandom();
    }

    private EncryptedPrivateKeyData createPrivateKeySequence(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] chain) throws CertificateEncodingException {
        org.openecard.bouncycastle.asn1.x509.Certificate[] certChain = new org.openecard.bouncycastle.asn1.x509.Certificate[chain.length];
        for (int i = 0; i != chain.length; ++i) {
            certChain[i] = org.openecard.bouncycastle.asn1.x509.Certificate.getInstance(chain[i].getEncoded());
        }
        return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certChain);
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] keyBytes, Certificate[] chain) throws KeyStoreException {
        Date creationDate;
        Date lastEditDate = creationDate = new Date();
        ObjectData entry = this.entries.get(alias);
        if (entry != null) {
            creationDate = this.extractCreationDate(entry, creationDate);
        }
        if (chain != null) {
            EncryptedPrivateKeyInfo encInfo;
            try {
                encInfo = EncryptedPrivateKeyInfo.getInstance(keyBytes);
            }
            catch (Exception e) {
                throw new ExtKeyStoreException("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", e);
            }
            try {
                this.privateKeyCache.remove(alias);
                this.entries.put(alias, new ObjectData(PROTECTED_PRIVATE_KEY, alias, creationDate, lastEditDate, this.createPrivateKeySequence(encInfo, chain).getEncoded(), null));
            }
            catch (Exception e) {
                throw new ExtKeyStoreException("BCFKS KeyStore exception storing protected private key: " + e.toString(), e);
            }
        }
        try {
            this.entries.put(alias, new ObjectData(PROTECTED_SECRET_KEY, alias, creationDate, lastEditDate, keyBytes, null));
        }
        catch (Exception e) {
            throw new ExtKeyStoreException("BCFKS KeyStore exception storing protected private key: " + e.toString(), e);
        }
        this.lastModifiedDate = lastEditDate;
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate certificate) throws KeyStoreException {
        Date creationDate;
        ObjectData entry = this.entries.get(alias);
        Date lastEditDate = creationDate = new Date();
        if (entry != null) {
            if (!entry.getType().equals(CERTIFICATE)) {
                throw new KeyStoreException("BCFKS KeyStore already has a key entry with alias " + alias);
            }
            creationDate = this.extractCreationDate(entry, creationDate);
        }
        try {
            this.entries.put(alias, new ObjectData(CERTIFICATE, alias, creationDate, lastEditDate, certificate.getEncoded(), null));
        }
        catch (CertificateEncodingException e) {
            throw new ExtKeyStoreException("BCFKS KeyStore unable to handle certificate: " + e.getMessage(), e);
        }
        this.lastModifiedDate = lastEditDate;
    }

    private Date extractCreationDate(ObjectData entry, Date creationDate) {
        try {
            creationDate = entry.getCreationDate().getDate();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return creationDate;
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        ObjectData entry = this.entries.get(alias);
        if (entry == null) {
            return;
        }
        this.privateKeyCache.remove(alias);
        this.entries.remove(alias);
        this.lastModifiedDate = new Date();
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<String> it = new HashSet<String>(this.entries.keySet()).iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            public Object nextElement() {
                return it.next();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        if (alias == null) {
            throw new NullPointerException("alias value is null");
        }
        return this.entries.containsKey(alias);
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        ObjectData ent = this.entries.get(alias);
        if (ent != null) {
            BigInteger entryType = ent.getType();
            return entryType.equals(PRIVATE_KEY) || entryType.equals(SECRET_KEY) || entryType.equals(PROTECTED_PRIVATE_KEY) || entryType.equals(PROTECTED_SECRET_KEY);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        ObjectData ent = this.entries.get(alias);
        if (ent != null) {
            return ent.getType().equals(CERTIFICATE);
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        byte[] encodedCert;
        if (certificate == null) {
            return null;
        }
        try {
            encodedCert = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            return null;
        }
        for (String alias : this.entries.keySet()) {
            ObjectData ent = this.entries.get(alias);
            if (ent.getType().equals(CERTIFICATE)) {
                if (!Arrays.areEqual(ent.getData(), encodedCert)) continue;
                return alias;
            }
            if (!ent.getType().equals(PRIVATE_KEY) && !ent.getType().equals(PROTECTED_PRIVATE_KEY)) continue;
            try {
                EncryptedPrivateKeyData encPrivData = EncryptedPrivateKeyData.getInstance(ent.getData());
                if (!Arrays.areEqual(encPrivData.getCertificateChain()[0].toASN1Primitive().getEncoded(), encodedCert)) continue;
                return alias;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private byte[] generateKey(KeyDerivationFunc pbkdAlgorithm, String purpose, char[] password) throws IOException {
        PBKDF2Params pbkdf2Params;
        byte[] encPassword = PBEParametersGenerator.PKCS12PasswordToBytes(password);
        byte[] differentiator = PBEParametersGenerator.PKCS12PasswordToBytes(purpose.toCharArray());
        PKCS5S2ParametersGenerator pGen = new PKCS5S2ParametersGenerator(new SHA512Digest());
        if (pbkdAlgorithm.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) {
            pbkdf2Params = PBKDF2Params.getInstance(pbkdAlgorithm.getParameters());
            if (!pbkdf2Params.getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD PRF.");
            }
        } else {
            throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
        }
        pGen.init(Arrays.concatenate(encPassword, differentiator), pbkdf2Params.getSalt(), pbkdf2Params.getIterationCount().intValue());
        int keySizeInBytes = pbkdf2Params.getKeyLength().intValue();
        return ((KeyParameter)pGen.generateDerivedParameters(keySizeInBytes * 8)).getKey();
    }

    private void verifyMac(byte[] content, PbkdMacIntegrityCheck integrityCheck, char[] password) throws NoSuchAlgorithmException, IOException {
        byte[] check = this.calculateMac(content, integrityCheck.getMacAlgorithm(), integrityCheck.getPbkdAlgorithm(), password);
        if (!Arrays.constantTimeAreEqual(check, integrityCheck.getMac())) {
            throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed.");
        }
    }

    private byte[] calculateMac(byte[] content, AlgorithmIdentifier algorithm, KeyDerivationFunc pbkdAlgorithm, char[] password) throws NoSuchAlgorithmException, IOException {
        String algorithmId = algorithm.getAlgorithm().getId();
        Mac mac = this.provider != null ? Mac.getInstance(algorithmId, this.provider) : Mac.getInstance(algorithmId);
        try {
            mac.init(new SecretKeySpec(this.generateKey(pbkdAlgorithm, "INTEGRITY_CHECK", password != null ? password : new char[]{}), algorithmId));
        }
        catch (InvalidKeyException e) {
            throw new IOException("Cannot set up MAC calculation: " + e.getMessage());
        }
        return mac.doFinal(content);
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        EncryptedObjectStoreData encStoreData;
        ObjectData[] dataArray = this.entries.values().toArray(new ObjectData[this.entries.size()]);
        KeyDerivationFunc pbkdAlgId = this.generatePkbdAlgorithmIdentifier(32);
        byte[] keyBytes = this.generateKey(pbkdAlgId, "STORE_ENCRYPTION", password != null ? password : new char[]{});
        ObjectStoreData storeData = new ObjectStoreData(this.hmacAlgorithm, this.creationDate, this.lastModifiedDate, new ObjectDataSequence(dataArray), null);
        try {
            Cipher c = this.provider == null ? Cipher.getInstance("AES/CCM/NoPadding") : Cipher.getInstance("AES/CCM/NoPadding", this.provider);
            c.init(1, new SecretKeySpec(keyBytes, "AES"));
            byte[] encOut = c.doFinal(storeData.getEncoded());
            AlgorithmParameters algorithmParameters = c.getParameters();
            PBES2Parameters pbeParams = new PBES2Parameters(pbkdAlgId, new EncryptionScheme(NISTObjectIdentifiers.id_aes256_CCM, CCMParameters.getInstance(algorithmParameters.getEncoded())));
            encStoreData = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, pbeParams), encOut);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (BadPaddingException e) {
            throw new IOException(e.toString());
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new IOException(e.toString());
        }
        PBKDF2Params pbkdf2Params = PBKDF2Params.getInstance(this.hmacPkbdAlgorithm.getParameters());
        byte[] pbkdSalt = new byte[pbkdf2Params.getSalt().length];
        this.getDefaultSecureRandom().nextBytes(pbkdSalt);
        this.hmacPkbdAlgorithm = new KeyDerivationFunc(this.hmacPkbdAlgorithm.getAlgorithm(), new PBKDF2Params(pbkdSalt, pbkdf2Params.getIterationCount().intValue(), pbkdf2Params.getKeyLength().intValue(), pbkdf2Params.getPrf()));
        byte[] mac = this.calculateMac(encStoreData.getEncoded(), this.hmacAlgorithm, this.hmacPkbdAlgorithm, password);
        ObjectStore store = new ObjectStore(encStoreData, new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(this.hmacAlgorithm, this.hmacPkbdAlgorithm, mac)));
        outputStream.write(store.getEncoded());
        outputStream.flush();
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        ObjectStoreData storeData;
        this.entries.clear();
        this.privateKeyCache.clear();
        this.creationDate = null;
        this.lastModifiedDate = null;
        this.hmacAlgorithm = null;
        if (inputStream == null) {
            this.lastModifiedDate = this.creationDate = new Date();
            this.hmacAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
            this.hmacPkbdAlgorithm = this.generatePkbdAlgorithmIdentifier(64);
            return;
        }
        ASN1InputStream aIn = new ASN1InputStream(inputStream);
        ObjectStore store = ObjectStore.getInstance(aIn.readObject());
        ObjectStoreIntegrityCheck integrityCheck = store.getIntegrityCheck();
        if (integrityCheck.getType() != 0) {
            throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
        }
        PbkdMacIntegrityCheck pbkdMacIntegrityCheck = PbkdMacIntegrityCheck.getInstance(integrityCheck.getIntegrityCheck());
        this.hmacAlgorithm = pbkdMacIntegrityCheck.getMacAlgorithm();
        this.hmacPkbdAlgorithm = pbkdMacIntegrityCheck.getPbkdAlgorithm();
        this.verifyMac(store.getStoreData().toASN1Primitive().getEncoded(), pbkdMacIntegrityCheck, password);
        ASN1Encodable sData = store.getStoreData();
        if (sData instanceof EncryptedObjectStoreData) {
            EncryptedObjectStoreData encryptedStoreData = (EncryptedObjectStoreData)sData;
            AlgorithmIdentifier protectAlgId = encryptedStoreData.getEncryptionAlgorithm();
            storeData = ObjectStoreData.getInstance(this.decryptData("STORE_ENCRYPTION", protectAlgId, password, encryptedStoreData.getEncryptedContent().getOctets()));
        } else {
            storeData = ObjectStoreData.getInstance(sData);
        }
        try {
            this.creationDate = storeData.getCreationDate().getDate();
            this.lastModifiedDate = storeData.getLastModifiedDate().getDate();
        }
        catch (ParseException e) {
            throw new IOException("BCFKS KeyStore unable to parse store data information.");
        }
        if (!storeData.getIntegrityAlgorithm().equals(this.hmacAlgorithm)) {
            throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
        }
        Iterator<ASN1Encodable> it = storeData.getObjectDataSequence().iterator();
        while (it.hasNext()) {
            ObjectData objData = ObjectData.getInstance(it.next());
            this.entries.put(objData.getIdentifier(), objData);
        }
    }

    private byte[] decryptData(String purpose, AlgorithmIdentifier protectAlgId, char[] password, byte[] encryptedData) throws IOException {
        if (!protectAlgId.getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
            throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
        }
        PBES2Parameters pbes2Parameters = PBES2Parameters.getInstance(protectAlgId.getParameters());
        EncryptionScheme algId = pbes2Parameters.getEncryptionScheme();
        if (!algId.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
            throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
        }
        try {
            AlgorithmParameters algParams;
            Cipher c;
            CCMParameters ccmParameters = CCMParameters.getInstance(algId.getParameters());
            if (this.provider == null) {
                c = Cipher.getInstance("AES/CCM/NoPadding");
                algParams = AlgorithmParameters.getInstance("CCM");
            } else {
                c = Cipher.getInstance("AES/CCM/NoPadding", this.provider);
                algParams = AlgorithmParameters.getInstance("CCM", this.provider);
            }
            algParams.init(ccmParameters.getEncoded());
            byte[] keyBytes = this.generateKey(pbes2Parameters.getKeyDerivationFunc(), purpose, password != null ? password : new char[]{});
            c.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), algParams);
            byte[] rv = c.doFinal(encryptedData);
            return rv;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private KeyDerivationFunc generatePkbdAlgorithmIdentifier(int keySizeInBytes) {
        byte[] pbkdSalt = new byte[64];
        this.getDefaultSecureRandom().nextBytes(pbkdSalt);
        return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(pbkdSalt, 1024, keySizeInBytes, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE)));
    }

    static {
        oidMap.put("DESEDE", OIWObjectIdentifiers.desEDE);
        oidMap.put("TRIPLEDES", OIWObjectIdentifiers.desEDE);
        oidMap.put("TDEA", OIWObjectIdentifiers.desEDE);
        oidMap.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        oidMap.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        oidMap.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        oidMap.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        oidMap.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        publicAlgMap.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        publicAlgMap.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        publicAlgMap.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        publicAlgMap.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        publicAlgMap.put(X9ObjectIdentifiers.id_dsa, "DSA");
        CERTIFICATE = BigInteger.valueOf(0L);
        PRIVATE_KEY = BigInteger.valueOf(1L);
        SECRET_KEY = BigInteger.valueOf(2L);
        PROTECTED_PRIVATE_KEY = BigInteger.valueOf(3L);
        PROTECTED_SECRET_KEY = BigInteger.valueOf(4L);
    }

    private static class ExtKeyStoreException
    extends KeyStoreException {
        private final Throwable cause;

        ExtKeyStoreException(String msg, Throwable cause) {
            super(msg);
            this.cause = cause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    public static class Def
    extends BcFKSKeyStoreSpi {
        public Def() {
            super(null);
        }
    }

    public static class Std
    extends BcFKSKeyStoreSpi {
        public Std() {
            super(new BouncyCastleProvider());
        }
    }
}

