/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce.provider.drbg;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.openecard.bouncycastle.crypto.digests.SHA512Digest;
import org.openecard.bouncycastle.crypto.macs.HMac;
import org.openecard.bouncycastle.crypto.prng.EntropySource;
import org.openecard.bouncycastle.crypto.prng.EntropySourceProvider;
import org.openecard.bouncycastle.crypto.prng.SP800SecureRandom;
import org.openecard.bouncycastle.crypto.prng.SP800SecureRandomBuilder;
import org.openecard.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.openecard.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import org.openecard.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Pack;
import org.openecard.bouncycastle.util.Strings;

public class DRBG {
    private static final String PREFIX = DRBG.class.getName();
    private static final String[][] initialEntropySourceNames = new String[][]{{"sun.security.provider.Sun", "sun.security.provider.SecureRandom"}, {"org.apache.harmony.security.provider.crypto.CryptoProvider", "org.apache.harmony.security.provider.crypto.SHA1PRNG_SecureRandomImpl"}, {"com.android.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLRandom"}, {"org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLRandom"}};
    private static final Object[] initialEntropySourceAndSpi = DRBG.findSource();

    private static final Object[] findSource() {
        for (int t = 0; t < initialEntropySourceNames.length; ++t) {
            String[] pair = initialEntropySourceNames[t];
            try {
                Object[] r = new Object[]{Class.forName(pair[0]).newInstance(), Class.forName(pair[1]).newInstance()};
                return r;
            }
            catch (Throwable ex) {
                continue;
            }
        }
        return null;
    }

    private static SecureRandom createInitialEntropySource() {
        if (initialEntropySourceAndSpi != null) {
            return new CoreSecureRandom();
        }
        return new SecureRandom();
    }

    private static EntropySourceProvider createEntropySource() {
        final String sourceClass = System.getProperty("org.openecard.bouncycastle.drbg.entropysource");
        return AccessController.doPrivileged(new PrivilegedAction<EntropySourceProvider>(){

            @Override
            public EntropySourceProvider run() {
                try {
                    Class clazz = ClassUtil.loadClass(DRBG.class, sourceClass);
                    return (EntropySourceProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("entropy source " + sourceClass + " not created: " + e.getMessage(), e);
                }
            }
        });
    }

    private static SecureRandom createBaseRandom(boolean isPredictionResistant) {
        if (System.getProperty("org.openecard.bouncycastle.drbg.entropysource") != null) {
            EntropySourceProvider entropyProvider = DRBG.createEntropySource();
            EntropySource initSource = entropyProvider.get(128);
            byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(initSource.getEntropy()) : DRBG.generateNonceIVPersonalizationString(initSource.getEntropy());
            return new SP800SecureRandomBuilder(entropyProvider).setPersonalizationString(personalisationString).buildHash(new SHA512Digest(), Arrays.concatenate(initSource.getEntropy(), initSource.getEntropy()), isPredictionResistant);
        }
        HybridSecureRandom randomSource = new HybridSecureRandom();
        byte[] personalisationString = isPredictionResistant ? DRBG.generateDefaultPersonalizationString(((SecureRandom)randomSource).generateSeed(16)) : DRBG.generateNonceIVPersonalizationString(((SecureRandom)randomSource).generateSeed(16));
        return new SP800SecureRandomBuilder(randomSource, true).setPersonalizationString(personalisationString).buildHash(new SHA512Digest(), ((SecureRandom)randomSource).generateSeed(32), isPredictionResistant);
    }

    private static byte[] generateDefaultPersonalizationString(byte[] seed) {
        return Arrays.concatenate(Strings.toByteArray("Default"), seed, Pack.longToBigEndian(Thread.currentThread().getId()), Pack.longToBigEndian(System.currentTimeMillis()));
    }

    private static byte[] generateNonceIVPersonalizationString(byte[] seed) {
        return Arrays.concatenate(Strings.toByteArray("Nonce"), seed, Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    static /* synthetic */ SecureRandom access$100(boolean x0) {
        return DRBG.createBaseRandom(x0);
    }

    static /* synthetic */ SecureRandom access$300() {
        return DRBG.createInitialEntropySource();
    }

    private static class HybridSecureRandom
    extends SecureRandom {
        private final AtomicBoolean seedAvailable = new AtomicBoolean(false);
        private final AtomicInteger samples = new AtomicInteger(0);
        private final SecureRandom baseRandom = DRBG.access$300();
        private final SP800SecureRandom drbg = new SP800SecureRandomBuilder(new EntropySourceProvider(){

            @Override
            public EntropySource get(int bitsRequired) {
                return new SignallingEntropySource(bitsRequired);
            }
        }).setPersonalizationString(Strings.toByteArray("Bouncy Castle Hybrid Entropy Source")).buildHMAC(new HMac(new SHA512Digest()), this.baseRandom.generateSeed(32), false);

        HybridSecureRandom() {
            super(null, null);
        }

        @Override
        public void setSeed(byte[] seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public void setSeed(long seed) {
            if (this.drbg != null) {
                this.drbg.setSeed(seed);
            }
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            byte[] data = new byte[numBytes];
            if (this.samples.getAndIncrement() > 20 && this.seedAvailable.getAndSet(false)) {
                this.samples.set(0);
                this.drbg.reseed((byte[])null);
            }
            this.drbg.nextBytes(data);
            return data;
        }

        private class SignallingEntropySource
        implements EntropySource {
            private final int byteLength;
            private final AtomicReference entropy = new AtomicReference();
            private final AtomicBoolean scheduled = new AtomicBoolean(false);

            SignallingEntropySource(int bitsRequired) {
                this.byteLength = (bitsRequired + 7) / 8;
            }

            @Override
            public boolean isPredictionResistant() {
                return true;
            }

            @Override
            public byte[] getEntropy() {
                byte[] seed = this.entropy.getAndSet(null);
                if (seed == null || seed.length != this.byteLength) {
                    seed = HybridSecureRandom.this.baseRandom.generateSeed(this.byteLength);
                } else {
                    this.scheduled.set(false);
                }
                if (!this.scheduled.getAndSet(true)) {
                    new Thread(new EntropyGatherer(this.byteLength)).start();
                }
                return seed;
            }

            @Override
            public int entropySize() {
                return this.byteLength * 8;
            }

            private class EntropyGatherer
            implements Runnable {
                private final int numBytes;

                EntropyGatherer(int numBytes) {
                    this.numBytes = numBytes;
                }

                @Override
                public void run() {
                    SignallingEntropySource.this.entropy.set(HybridSecureRandom.this.baseRandom.generateSeed(this.numBytes));
                    HybridSecureRandom.this.seedAvailable.set(true);
                }
            }
        }
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecureRandom.DEFAULT", PREFIX + "$Default");
            provider.addAlgorithm("SecureRandom.NONCEANDIV", PREFIX + "$NonceAndIV");
        }
    }

    public static class NonceAndIV
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(false);

        @Override
        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    public static class Default
    extends SecureRandomSpi {
        private static final SecureRandom random = DRBG.access$100(true);

        @Override
        protected void engineSetSeed(byte[] bytes) {
            random.setSeed(bytes);
        }

        @Override
        protected void engineNextBytes(byte[] bytes) {
            random.nextBytes(bytes);
        }

        @Override
        protected byte[] engineGenerateSeed(int numBytes) {
            return random.generateSeed(numBytes);
        }
    }

    private static class CoreSecureRandom
    extends SecureRandom {
        CoreSecureRandom() {
            super((SecureRandomSpi)initialEntropySourceAndSpi[1], (Provider)initialEntropySourceAndSpi[0]);
        }
    }
}

