/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.modes;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.BufferedBlockCipher;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.DataLengthException;
import org.openecard.bouncycastle.crypto.InvalidCipherTextException;
import org.openecard.bouncycastle.crypto.OutputLengthException;
import org.openecard.bouncycastle.crypto.modes.AEADBlockCipher;
import org.openecard.bouncycastle.crypto.modes.KCTRBlockCipher;
import org.openecard.bouncycastle.crypto.params.AEADParameters;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.BigIntegers;

public class KGCMBlockCipher
implements AEADBlockCipher {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger MASK_1_128 = new BigInteger("340282366920938463463374607431768211456", 10);
    private static final BigInteger MASK_2_128 = new BigInteger("340282366920938463463374607431768211455", 10);
    private static final BigInteger POLYRED_128 = new BigInteger("135", 10);
    private static final BigInteger MASK_1_256 = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639936", 10);
    private static final BigInteger MASK_2_256 = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639935", 10);
    private static final BigInteger POLYRED_256 = new BigInteger("1061", 10);
    private static final BigInteger MASK_1_512 = new BigInteger("13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084096", 10);
    private static final BigInteger MASK_2_512 = new BigInteger("13407807929942597099574024998205846127479365820592393377723561443721764030073546976801874298166903427690031858186486050853753882811946569946433649006084095", 10);
    private static final BigInteger POLYRED_512 = new BigInteger("293", 10);
    private static final int MIN_MAC_BITS = 64;
    private static final int BITS_IN_BYTE = 8;
    private BlockCipher engine;
    private BufferedBlockCipher ctrEngine;
    private int macSize;
    private boolean forEncryption;
    private byte[] initialAssociatedText;
    private byte[] macBlock;
    private byte[] iv;
    private byte[] H;
    private byte[] b;
    private byte[] temp;
    private int lambda_o;
    private int lambda_c;
    private ExposedByteArrayOutputStream associatedText = new ExposedByteArrayOutputStream();
    private ExposedByteArrayOutputStream data = new ExposedByteArrayOutputStream();

    public KGCMBlockCipher(BlockCipher dstu7624Engine) {
        this.engine = dstu7624Engine;
        this.ctrEngine = new BufferedBlockCipher(new KCTRBlockCipher(this.engine));
        this.macSize = 0;
        this.initialAssociatedText = new byte[this.engine.getBlockSize()];
        this.iv = new byte[this.engine.getBlockSize()];
        this.H = new byte[this.engine.getBlockSize()];
        this.b = new byte[this.engine.getBlockSize()];
        this.temp = new byte[this.engine.getBlockSize()];
        this.lambda_c = 0;
        this.lambda_o = 0;
        this.macBlock = null;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        KeyParameter engineParam;
        this.forEncryption = forEncryption;
        if (params instanceof AEADParameters) {
            AEADParameters param = (AEADParameters)params;
            byte[] iv = param.getNonce();
            int diff = this.iv.length - iv.length;
            Arrays.fill(this.iv, (byte)0);
            System.arraycopy(iv, 0, this.iv, diff, iv.length);
            this.initialAssociatedText = param.getAssociatedText();
            int macSizeBits = param.getMacSize();
            if (macSizeBits < 64 || macSizeBits > this.engine.getBlockSize() * 8 || macSizeBits % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
            this.macSize = macSizeBits / 8;
            engineParam = param.getKey();
            if (this.initialAssociatedText != null) {
                this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV param = (ParametersWithIV)params;
            byte[] iv = param.getIV();
            int diff = this.iv.length - iv.length;
            Arrays.fill(this.iv, (byte)0);
            System.arraycopy(iv, 0, this.iv, diff, iv.length);
            this.initialAssociatedText = null;
            this.macSize = this.engine.getBlockSize();
            engineParam = (KeyParameter)param.getParameters();
        } else {
            throw new IllegalArgumentException("Invalid parameter passed");
        }
        this.macBlock = new byte[this.engine.getBlockSize()];
        this.ctrEngine.init(true, new ParametersWithIV(engineParam, this.iv));
        this.engine.init(true, engineParam);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KGCM";
    }

    @Override
    public BlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void processAADByte(byte in) {
        this.associatedText.write(in);
    }

    @Override
    public void processAADBytes(byte[] in, int inOff, int len) {
        this.associatedText.write(in, inOff, len);
    }

    private void processAAD(byte[] authText, int authOff, int len) {
        this.lambda_o = len * 8;
        this.engine.processBlock(this.H, 0, this.H, 0);
        int totalLength = len;
        int inOff_ = authOff;
        while (totalLength > 0) {
            for (int byteIndex = 0; byteIndex < this.engine.getBlockSize(); ++byteIndex) {
                int n = byteIndex;
                this.b[n] = (byte)(this.b[n] ^ authText[inOff_ + byteIndex]);
            }
            this.multiplyOverField(this.engine.getBlockSize() * 8, this.b, this.H, this.temp);
            this.temp = Arrays.reverse(this.temp);
            System.arraycopy(this.temp, 0, this.b, 0, this.engine.getBlockSize());
            totalLength -= this.engine.getBlockSize();
            inOff_ += this.engine.getBlockSize();
        }
    }

    @Override
    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        this.data.write(in);
        return 0;
    }

    @Override
    public int processBytes(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (in.length < inOff + inLen) {
            throw new DataLengthException("input buffer too short");
        }
        this.data.write(in, inOff, inLen);
        return 0;
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int resultLen;
        int len = this.data.size();
        if (this.associatedText.size() > 0) {
            this.processAAD(this.associatedText.getBuffer(), 0, this.associatedText.size());
        }
        if (this.forEncryption) {
            if (out.length - outOff < len + this.macSize) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.lambda_c = len * 8;
            resultLen = this.ctrEngine.processBytes(this.data.getBuffer(), 0, len, out, outOff);
            resultLen += this.ctrEngine.doFinal(out, outOff + resultLen);
            this.calculateMac(out, outOff, len);
        } else {
            this.lambda_c = (len - this.macSize) * 8;
            this.calculateMac(this.data.getBuffer(), 0, len - this.macSize);
            resultLen = this.ctrEngine.processBytes(this.data.getBuffer(), 0, len - this.macSize, out, outOff);
            resultLen += this.ctrEngine.doFinal(out, outOff + resultLen);
        }
        outOff += resultLen;
        if (this.macBlock == null) {
            throw new IllegalStateException("mac is not calculated");
        }
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, out, outOff, this.macSize);
            this.reset();
            return resultLen + this.macSize;
        }
        byte[] mac = new byte[this.macSize];
        System.arraycopy(this.data.getBuffer(), resultLen, mac, 0, this.macSize);
        byte[] calculatedMac = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, calculatedMac, 0, this.macSize);
        if (!Arrays.constantTimeAreEqual(mac, calculatedMac)) {
            throw new InvalidCipherTextException("mac verification failed");
        }
        this.reset();
        return resultLen;
    }

    @Override
    public byte[] getMac() {
        byte[] mac = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, mac, 0, this.macSize);
        return mac;
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return len;
    }

    @Override
    public int getOutputSize(int len) {
        if (this.forEncryption) {
            return len;
        }
        return len + this.macSize;
    }

    @Override
    public void reset() {
        this.H = new byte[this.engine.getBlockSize()];
        this.b = new byte[this.engine.getBlockSize()];
        this.temp = new byte[this.engine.getBlockSize()];
        this.lambda_c = 0;
        this.lambda_o = 0;
        this.engine.reset();
        this.data.reset();
        this.associatedText.reset();
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private void calculateMac(byte[] input, int inOff, int len) {
        int byteIndex;
        this.macBlock = new byte[this.engine.getBlockSize()];
        int totalLength = len;
        int inOff_ = inOff;
        while (totalLength > 0) {
            for (byteIndex = 0; byteIndex < this.engine.getBlockSize(); ++byteIndex) {
                int n = byteIndex;
                this.b[n] = (byte)(this.b[n] ^ input[byteIndex + inOff_]);
            }
            this.multiplyOverField(this.engine.getBlockSize() * 8, this.b, this.H, this.temp);
            this.temp = Arrays.reverse(this.temp);
            System.arraycopy(this.temp, 0, this.b, 0, this.engine.getBlockSize());
            totalLength -= this.engine.getBlockSize();
            inOff_ += this.engine.getBlockSize();
        }
        Arrays.fill(this.temp, (byte)0);
        this.intToBytes(this.lambda_o, this.temp, 0);
        this.intToBytes(this.lambda_c, this.temp, this.engine.getBlockSize() / 2);
        for (byteIndex = 0; byteIndex < this.engine.getBlockSize(); ++byteIndex) {
            int n = byteIndex;
            this.b[n] = (byte)(this.b[n] ^ this.temp[byteIndex]);
        }
        this.engine.processBlock(this.b, 0, this.macBlock, 0);
    }

    private void intToBytes(int num, byte[] outBytes, int outOff) {
        outBytes[outOff + 3] = (byte)(num >> 24);
        outBytes[outOff + 2] = (byte)(num >> 16);
        outBytes[outOff + 1] = (byte)(num >> 8);
        outBytes[outOff] = (byte)num;
    }

    private void multiplyOverField(int blockBitLength, byte[] x, byte[] y, byte[] x_mult_y) {
        BigInteger polyred;
        BigInteger mask2;
        BigInteger mask1;
        byte[] fieldOperationBuffer1 = new byte[this.engine.getBlockSize()];
        byte[] fieldOperationBuffer2 = new byte[this.engine.getBlockSize()];
        System.arraycopy(x, 0, fieldOperationBuffer1, 0, this.engine.getBlockSize());
        System.arraycopy(y, 0, fieldOperationBuffer2, 0, this.engine.getBlockSize());
        fieldOperationBuffer1 = Arrays.reverse(fieldOperationBuffer1);
        fieldOperationBuffer2 = Arrays.reverse(fieldOperationBuffer2);
        switch (blockBitLength) {
            case 128: {
                mask1 = MASK_1_128;
                mask2 = MASK_2_128;
                polyred = POLYRED_128;
                break;
            }
            case 256: {
                mask1 = MASK_1_256;
                mask2 = MASK_2_256;
                polyred = POLYRED_256;
                break;
            }
            case 512: {
                mask1 = MASK_1_512;
                mask2 = MASK_2_512;
                polyred = POLYRED_512;
                break;
            }
            default: {
                mask1 = MASK_1_128;
                mask2 = MASK_2_128;
                polyred = POLYRED_128;
            }
        }
        BigInteger p = ZERO;
        BigInteger p1 = new BigInteger(1, fieldOperationBuffer1);
        BigInteger p2 = new BigInteger(1, fieldOperationBuffer2);
        while (!p2.equals(ZERO)) {
            if (p2.and(ONE).equals(ONE)) {
                p = p.xor(p1);
            }
            if (!(p1 = p1.shiftLeft(1)).and(mask1).equals(ZERO)) {
                p1 = p1.xor(polyred);
            }
            p2 = p2.shiftRight(1);
        }
        byte[] got = BigIntegers.asUnsignedByteArray(p.and(mask2));
        Arrays.fill(x_mult_y, (byte)0);
        System.arraycopy(got, 0, x_mult_y, 0, got.length);
    }

    private class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

