/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.openecard.bouncycastle.crypto.KeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.ECDomainParameters;
import org.openecard.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.openecard.bouncycastle.math.ec.ECConstants;
import org.openecard.bouncycastle.math.ec.ECMultiplier;
import org.openecard.bouncycastle.math.ec.ECPoint;
import org.openecard.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.openecard.bouncycastle.math.ec.WNafUtil;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

