/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.openecard.bouncycastle.crypto.KeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import org.openecard.bouncycastle.crypto.params.DSAParameters;
import org.openecard.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.openecard.bouncycastle.math.ec.WNafUtil;
import org.openecard.bouncycastle.util.BigIntegers;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        BigInteger x;
        int minWeight = q.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(x = BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random)) < minWeight) {
        }
        return x;
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

