/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.engines;

import java.security.SecureRandom;
import org.openecard.bouncycastle.crypto.BlockCipher;
import org.openecard.bouncycastle.crypto.CipherParameters;
import org.openecard.bouncycastle.crypto.InvalidCipherTextException;
import org.openecard.bouncycastle.crypto.Wrapper;
import org.openecard.bouncycastle.crypto.modes.CBCBlockCipher;
import org.openecard.bouncycastle.crypto.params.ParametersWithIV;
import org.openecard.bouncycastle.crypto.params.ParametersWithRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher engine;
    private ParametersWithIV param;
    private boolean forWrapping;
    private SecureRandom rand;

    public RFC3211WrapEngine(BlockCipher engine) {
        this.engine = new CBCBlockCipher(engine);
    }

    @Override
    public void init(boolean forWrapping, CipherParameters param) {
        this.forWrapping = forWrapping;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom p = (ParametersWithRandom)param;
            this.rand = p.getRandom();
            this.param = (ParametersWithIV)p.getParameters();
        } else {
            if (forWrapping) {
                this.rand = new SecureRandom();
            }
            this.param = (ParametersWithIV)param;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        int i;
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.engine.init(true, this.param);
        int blockSize = this.engine.getBlockSize();
        byte[] cekBlock = inLen + 4 < blockSize * 2 ? new byte[blockSize * 2] : new byte[(inLen + 4) % blockSize == 0 ? inLen + 4 : ((inLen + 4) / blockSize + 1) * blockSize];
        cekBlock[0] = (byte)inLen;
        cekBlock[1] = ~in[inOff];
        cekBlock[2] = ~in[inOff + 1];
        cekBlock[3] = ~in[inOff + 2];
        System.arraycopy(in, inOff, cekBlock, 4, inLen);
        byte[] pad = new byte[cekBlock.length - (inLen + 4)];
        this.rand.nextBytes(pad);
        System.arraycopy(pad, 0, cekBlock, inLen + 4, pad.length);
        for (i = 0; i < cekBlock.length; i += blockSize) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
        }
        for (i = 0; i < cekBlock.length; i += blockSize) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
        }
        return cekBlock;
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        int i;
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int blockSize = this.engine.getBlockSize();
        if (inLen < 2 * blockSize) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] cekBlock = new byte[inLen];
        byte[] iv = new byte[blockSize];
        System.arraycopy(in, inOff, cekBlock, 0, inLen);
        System.arraycopy(in, inOff, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        for (i = blockSize; i < cekBlock.length; i += blockSize) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
        }
        System.arraycopy(cekBlock, cekBlock.length - iv.length, iv, 0, iv.length);
        this.engine.init(false, new ParametersWithIV(this.param.getParameters(), iv));
        this.engine.processBlock(cekBlock, 0, cekBlock, 0);
        this.engine.init(false, this.param);
        for (i = 0; i < cekBlock.length; i += blockSize) {
            this.engine.processBlock(cekBlock, i, cekBlock, i);
        }
        if ((cekBlock[0] & 0xFF) > cekBlock.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] key = new byte[cekBlock[0] & 0xFF];
        System.arraycopy(cekBlock, 4, key, 0, cekBlock[0]);
        int nonEqual = 0;
        for (int i2 = 0; i2 != 3; ++i2) {
            byte check = ~cekBlock[1 + i2];
            nonEqual |= check ^ key[i2];
        }
        if (nonEqual != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return key;
    }
}

