/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.crypto.digests;

import org.openecard.bouncycastle.crypto.ExtendedDigest;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Pack;

public class KeccakDigest
implements ExtendedDigest {
    private static long[] KeccakRoundConstants = KeccakDigest.keccakInitializeRoundConstants();
    private static int[] KeccakRhoOffsets = KeccakDigest.keccakInitializeRhoOffsets();
    protected long[] state = new long[25];
    protected byte[] dataQueue = new byte[192];
    protected int rate;
    protected int bitsInQueue;
    protected int fixedOutputLength;
    protected boolean squeezing;

    private static long[] keccakInitializeRoundConstants() {
        long[] keccakRoundConstants = new long[24];
        byte[] LFSRstate = new byte[]{1};
        for (int i = 0; i < 24; ++i) {
            keccakRoundConstants[i] = 0L;
            for (int j = 0; j < 7; ++j) {
                int bitPosition = (1 << j) - 1;
                if (!KeccakDigest.LFSR86540(LFSRstate)) continue;
                int n = i;
                keccakRoundConstants[n] = keccakRoundConstants[n] ^ 1L << bitPosition;
            }
        }
        return keccakRoundConstants;
    }

    private static boolean LFSR86540(byte[] LFSR) {
        boolean result = (LFSR[0] & 1) != 0;
        LFSR[0] = (LFSR[0] & 0x80) != 0 ? (byte)(LFSR[0] << 1 ^ 0x71) : (byte)(LFSR[0] << 1);
        return result;
    }

    private static int[] keccakInitializeRhoOffsets() {
        int[] keccakRhoOffsets = new int[25];
        keccakRhoOffsets[0] = 0;
        int x = 1;
        int y = 0;
        for (int t = 0; t < 24; ++t) {
            keccakRhoOffsets[x % 5 + 5 * (y % 5)] = (t + 1) * (t + 2) / 2 % 64;
            int newX = (0 * x + 1 * y) % 5;
            int newY = (2 * x + 3 * y) % 5;
            x = newX;
            y = newY;
        }
        return keccakRhoOffsets;
    }

    public KeccakDigest() {
        this(288);
    }

    public KeccakDigest(int bitLength) {
        this.init(bitLength);
    }

    public KeccakDigest(KeccakDigest source) {
        System.arraycopy(source.state, 0, this.state, 0, source.state.length);
        System.arraycopy(source.dataQueue, 0, this.dataQueue, 0, source.dataQueue.length);
        this.rate = source.rate;
        this.bitsInQueue = source.bitsInQueue;
        this.fixedOutputLength = source.fixedOutputLength;
        this.squeezing = source.squeezing;
    }

    @Override
    public String getAlgorithmName() {
        return "Keccak-" + this.fixedOutputLength;
    }

    @Override
    public int getDigestSize() {
        return this.fixedOutputLength / 8;
    }

    @Override
    public void update(byte in) {
        this.absorb(new byte[]{in}, 0, 1);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.absorb(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        this.squeeze(out, outOff, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    protected int doFinal(byte[] out, int outOff, byte partialByte, int partialBits) {
        if (partialBits > 0) {
            this.absorbBits(partialByte, partialBits);
        }
        this.squeeze(out, outOff, this.fixedOutputLength);
        this.reset();
        return this.getDigestSize();
    }

    @Override
    public void reset() {
        this.init(this.fixedOutputLength);
    }

    @Override
    public int getByteLength() {
        return this.rate / 8;
    }

    private void init(int bitLength) {
        switch (bitLength) {
            case 128: 
            case 224: 
            case 256: 
            case 288: 
            case 384: 
            case 512: {
                this.initSponge(1600 - (bitLength << 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("bitLength must be one of 128, 224, 256, 288, 384, or 512.");
            }
        }
    }

    private void initSponge(int rate) {
        if (rate <= 0 || rate >= 1600 || rate % 64 != 0) {
            throw new IllegalStateException("invalid rate value");
        }
        this.rate = rate;
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = 0L;
        }
        Arrays.fill(this.dataQueue, (byte)0);
        this.bitsInQueue = 0;
        this.squeezing = false;
        this.fixedOutputLength = (1600 - rate) / 2;
    }

    protected void absorb(byte[] data, int off, int len) {
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        int bytesInQueue = this.bitsInQueue >> 3;
        int rateBytes = this.rate >> 3;
        int count = 0;
        while (count < len) {
            if (bytesInQueue == 0 && count <= len - rateBytes) {
                do {
                    this.KeccakAbsorb(data, off + count);
                } while ((count += rateBytes) <= len - rateBytes);
                continue;
            }
            int partialBlock = Math.min(rateBytes - bytesInQueue, len - count);
            System.arraycopy(data, off + count, this.dataQueue, bytesInQueue, partialBlock);
            count += partialBlock;
            if ((bytesInQueue += partialBlock) != rateBytes) continue;
            this.KeccakAbsorb(this.dataQueue, 0);
            bytesInQueue = 0;
        }
        this.bitsInQueue = bytesInQueue << 3;
    }

    protected void absorbBits(int data, int bits) {
        if (bits < 1 || bits > 7) {
            throw new IllegalArgumentException("'bits' must be in the range 1 to 7");
        }
        if (this.bitsInQueue % 8 != 0) {
            throw new IllegalStateException("attempt to absorb with odd length queue");
        }
        if (this.squeezing) {
            throw new IllegalStateException("attempt to absorb while squeezing");
        }
        int mask = (1 << bits) - 1;
        this.dataQueue[this.bitsInQueue >> 3] = (byte)(data & mask);
        this.bitsInQueue += bits;
    }

    private void padAndSwitchToSqueezingPhase() {
        int n = this.bitsInQueue >> 3;
        this.dataQueue[n] = (byte)(this.dataQueue[n] | (byte)(1L << (this.bitsInQueue & 7)));
        if (++this.bitsInQueue == this.rate) {
            this.KeccakAbsorb(this.dataQueue, 0);
            this.bitsInQueue = 0;
        }
        int full = this.bitsInQueue >> 6;
        int partial = this.bitsInQueue & 0x3F;
        int off = 0;
        int i = 0;
        while (i < full) {
            int n2 = i++;
            this.state[n2] = this.state[n2] ^ Pack.littleEndianToLong(this.dataQueue, off);
            off += 8;
        }
        if (partial > 0) {
            long mask = (1L << partial) - 1L;
            int n3 = full;
            this.state[n3] = this.state[n3] ^ Pack.littleEndianToLong(this.dataQueue, off) & mask;
        }
        int n4 = this.rate - 1 >> 6;
        this.state[n4] = this.state[n4] ^ Long.MIN_VALUE;
        this.KeccakPermutation();
        this.KeccakExtract();
        this.bitsInQueue = this.rate;
        this.squeezing = true;
    }

    protected void squeeze(byte[] output, int offset, long outputLength) {
        int partialBlock;
        if (!this.squeezing) {
            this.padAndSwitchToSqueezingPhase();
        }
        if (outputLength % 8L != 0L) {
            throw new IllegalStateException("outputLength not a multiple of 8");
        }
        for (long i = 0L; i < outputLength; i += (long)partialBlock) {
            if (this.bitsInQueue == 0) {
                this.KeccakPermutation();
                this.KeccakExtract();
                this.bitsInQueue = this.rate;
            }
            partialBlock = (int)Math.min((long)this.bitsInQueue, outputLength - i);
            System.arraycopy(this.dataQueue, (this.rate - this.bitsInQueue) / 8, output, offset + (int)(i / 8L), partialBlock / 8);
            this.bitsInQueue -= partialBlock;
        }
    }

    private void KeccakAbsorb(byte[] data, int off) {
        int count = this.rate >> 6;
        int i = 0;
        while (i < count) {
            int n = i++;
            this.state[n] = this.state[n] ^ Pack.littleEndianToLong(data, off);
            off += 8;
        }
        this.KeccakPermutation();
    }

    private void KeccakExtract() {
        Pack.longToLittleEndian(this.state, 0, this.rate >> 6, this.dataQueue, 0);
    }

    private void KeccakPermutation() {
        for (int i = 0; i < 24; ++i) {
            KeccakDigest.theta(this.state);
            KeccakDigest.rho(this.state);
            KeccakDigest.pi(this.state);
            KeccakDigest.chi(this.state);
            KeccakDigest.iota(this.state, i);
        }
    }

    private static long leftRotate(long v, int r) {
        return v << r | v >>> -r;
    }

    private static void theta(long[] A) {
        long C0 = A[0] ^ A[5] ^ A[10] ^ A[15] ^ A[20];
        long C1 = A[1] ^ A[6] ^ A[11] ^ A[16] ^ A[21];
        long C2 = A[2] ^ A[7] ^ A[12] ^ A[17] ^ A[22];
        long C3 = A[3] ^ A[8] ^ A[13] ^ A[18] ^ A[23];
        long C4 = A[4] ^ A[9] ^ A[14] ^ A[19] ^ A[24];
        long dX = KeccakDigest.leftRotate(C1, 1) ^ C4;
        A[0] = A[0] ^ dX;
        A[5] = A[5] ^ dX;
        A[10] = A[10] ^ dX;
        A[15] = A[15] ^ dX;
        A[20] = A[20] ^ dX;
        dX = KeccakDigest.leftRotate(C2, 1) ^ C0;
        A[1] = A[1] ^ dX;
        A[6] = A[6] ^ dX;
        A[11] = A[11] ^ dX;
        A[16] = A[16] ^ dX;
        A[21] = A[21] ^ dX;
        dX = KeccakDigest.leftRotate(C3, 1) ^ C1;
        A[2] = A[2] ^ dX;
        A[7] = A[7] ^ dX;
        A[12] = A[12] ^ dX;
        A[17] = A[17] ^ dX;
        A[22] = A[22] ^ dX;
        dX = KeccakDigest.leftRotate(C4, 1) ^ C2;
        A[3] = A[3] ^ dX;
        A[8] = A[8] ^ dX;
        A[13] = A[13] ^ dX;
        A[18] = A[18] ^ dX;
        A[23] = A[23] ^ dX;
        dX = KeccakDigest.leftRotate(C0, 1) ^ C3;
        A[4] = A[4] ^ dX;
        A[9] = A[9] ^ dX;
        A[14] = A[14] ^ dX;
        A[19] = A[19] ^ dX;
        A[24] = A[24] ^ dX;
    }

    private static void rho(long[] A) {
        for (int x = 1; x < 25; ++x) {
            A[x] = KeccakDigest.leftRotate(A[x], KeccakRhoOffsets[x]);
        }
    }

    private static void pi(long[] A) {
        long a1 = A[1];
        A[1] = A[6];
        A[6] = A[9];
        A[9] = A[22];
        A[22] = A[14];
        A[14] = A[20];
        A[20] = A[2];
        A[2] = A[12];
        A[12] = A[13];
        A[13] = A[19];
        A[19] = A[23];
        A[23] = A[15];
        A[15] = A[4];
        A[4] = A[24];
        A[24] = A[21];
        A[21] = A[8];
        A[8] = A[16];
        A[16] = A[5];
        A[5] = A[3];
        A[3] = A[18];
        A[18] = A[17];
        A[17] = A[11];
        A[11] = A[7];
        A[7] = A[10];
        A[10] = a1;
    }

    private static void chi(long[] A) {
        for (int yBy5 = 0; yBy5 < 25; yBy5 += 5) {
            long chiC0 = A[0 + yBy5] ^ (A[1 + yBy5] ^ 0xFFFFFFFFFFFFFFFFL) & A[2 + yBy5];
            long chiC1 = A[1 + yBy5] ^ (A[2 + yBy5] ^ 0xFFFFFFFFFFFFFFFFL) & A[3 + yBy5];
            long chiC2 = A[2 + yBy5] ^ (A[3 + yBy5] ^ 0xFFFFFFFFFFFFFFFFL) & A[4 + yBy5];
            long chiC3 = A[3 + yBy5] ^ (A[4 + yBy5] ^ 0xFFFFFFFFFFFFFFFFL) & A[0 + yBy5];
            long chiC4 = A[4 + yBy5] ^ (A[0 + yBy5] ^ 0xFFFFFFFFFFFFFFFFL) & A[1 + yBy5];
            A[0 + yBy5] = chiC0;
            A[1 + yBy5] = chiC1;
            A[2 + yBy5] = chiC2;
            A[3 + yBy5] = chiC3;
            A[4 + yBy5] = chiC4;
        }
    }

    private static void iota(long[] A, int indexRound) {
        A[0] = A[0] ^ KeccakRoundConstants[indexRound];
    }
}

