/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openecard.bouncycastle.asn1.x500.X500Name;
import org.openecard.bouncycastle.cms.KeyTransRecipientId;
import org.openecard.bouncycastle.cms.Recipient;
import org.openecard.bouncycastle.cms.RecipientId;
import org.openecard.bouncycastle.cms.RecipientInformation;
import org.openecard.bouncycastle.util.Iterable;

public class RecipientInformationStore
implements Iterable<RecipientInformation> {
    private final List all;
    private final Map table = new HashMap();

    public RecipientInformationStore(RecipientInformation recipientInformation) {
        this.all = new ArrayList(1);
        this.all.add(recipientInformation);
        RecipientId sid = recipientInformation.getRID();
        this.table.put(sid, this.all);
    }

    public RecipientInformationStore(Collection<RecipientInformation> recipientInfos) {
        for (RecipientInformation recipientInformation : recipientInfos) {
            RecipientId rid = recipientInformation.getRID();
            ArrayList<RecipientInformation> list = (ArrayList<RecipientInformation>)this.table.get(rid);
            if (list == null) {
                list = new ArrayList<RecipientInformation>(1);
                this.table.put(rid, list);
            }
            list.add(recipientInformation);
        }
        this.all = new ArrayList<RecipientInformation>(recipientInfos);
    }

    public RecipientInformation get(RecipientId selector) {
        Collection<Recipient> list = this.getRecipients(selector);
        return list.size() == 0 ? null : (RecipientInformation)((Object)list.iterator().next());
    }

    public int size() {
        return this.all.size();
    }

    public Collection<RecipientInformation> getRecipients() {
        return new ArrayList<RecipientInformation>(this.all);
    }

    public Collection<Recipient> getRecipients(RecipientId selector) {
        ArrayList list;
        if (selector instanceof KeyTransRecipientId) {
            KeyTransRecipientId keyTrans = (KeyTransRecipientId)selector;
            X500Name issuer = keyTrans.getIssuer();
            byte[] subjectKeyId = keyTrans.getSubjectKeyIdentifier();
            if (issuer != null && subjectKeyId != null) {
                Collection<Recipient> match2;
                ArrayList<Recipient> results = new ArrayList<Recipient>();
                Collection<Recipient> match1 = this.getRecipients(new KeyTransRecipientId(issuer, keyTrans.getSerialNumber()));
                if (match1 != null) {
                    results.addAll(match1);
                }
                if ((match2 = this.getRecipients(new KeyTransRecipientId(subjectKeyId))) != null) {
                    results.addAll(match2);
                }
                return results;
            }
        }
        return (list = (ArrayList)this.table.get(selector)) == null ? new ArrayList<Recipient>() : new ArrayList(list);
    }

    @Override
    public Iterator<RecipientInformation> iterator() {
        return this.getRecipients().iterator();
    }
}

