/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms;

import org.openecard.bouncycastle.asn1.DEROctetString;
import org.openecard.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.openecard.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.openecard.bouncycastle.asn1.cms.RecipientIdentifier;
import org.openecard.bouncycastle.asn1.cms.RecipientInfo;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.RecipientInfoGenerator;
import org.openecard.bouncycastle.operator.AsymmetricKeyWrapper;
import org.openecard.bouncycastle.operator.GenericKey;
import org.openecard.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerial, AsymmetricKeyWrapper wrapper) {
        this.issuerAndSerial = issuerAndSerial;
        this.wrapper = wrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] subjectKeyIdentifier, AsymmetricKeyWrapper wrapper) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] encryptedKeyBytes;
        try {
            encryptedKeyBytes = this.wrapper.generateWrappedKey(contentEncryptionKey);
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
        RecipientIdentifier recipId = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(encryptedKeyBytes)));
    }
}

