/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cert.crmf;

import java.io.IOException;
import java.io.OutputStream;
import org.openecard.bouncycastle.asn1.cmp.PBMParameter;
import org.openecard.bouncycastle.asn1.crmf.PKMACValue;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.cert.crmf.CRMFException;
import org.openecard.bouncycastle.cert.crmf.PKMACBuilder;
import org.openecard.bouncycastle.operator.MacCalculator;
import org.openecard.bouncycastle.util.Arrays;

class PKMACValueVerifier {
    private final PKMACBuilder builder;

    public PKMACValueVerifier(PKMACBuilder builder) {
        this.builder = builder;
    }

    public boolean isValid(PKMACValue value, char[] password, SubjectPublicKeyInfo keyInfo) throws CRMFException {
        this.builder.setParameters(PBMParameter.getInstance(value.getAlgId().getParameters()));
        MacCalculator calculator = this.builder.build(password);
        OutputStream macOut = calculator.getOutputStream();
        try {
            macOut.write(keyInfo.getEncoded("DER"));
            macOut.close();
        }
        catch (IOException e) {
            throw new CRMFException("exception encoding mac input: " + e.getMessage(), e);
        }
        return Arrays.areEqual(calculator.getMac(), value.getValue().getBytes());
    }
}

