/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.message.BasicHttpRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.binding.tctoken.CertificateValidator;
import org.openecard.binding.tctoken.ResourceException;
import org.openecard.binding.tctoken.ValidationError;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidAddressException;
import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.I18nKey;
import org.openecard.common.io.LimitedInputStream;
import org.openecard.common.util.FileUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.Promise;
import org.openecard.common.util.TR03112Utils;
import org.openecard.crypto.common.ReusableSecureRandom;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.auth.DynamicAuthentication;
import org.openecard.crypto.tls.proxy.ProxySettings;
import org.openecard.crypto.tls.verify.JavaSecVerifier;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.HttpUtils;
import org.openecard.transport.httpcore.InvalidResultStatus;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.openecard.transport.httpcore.cookies.CookieException;
import org.openecard.transport.httpcore.cookies.CookieManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceContext {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceContext.class);
    private static final I18n LANG = I18n.getTranslation("tr03112");
    private final ClientCertTlsClient tlsClient;
    private final TlsClientProtocol tlsClientProto;
    private final List<Pair<URL, TlsServerCertificate>> certs;
    private InputStream stream;
    private String data;

    protected ResourceContext(@Nullable ClientCertTlsClient tlsClient, @Nullable TlsClientProtocol tlsClientProto, @Nonnull List<Pair<URL, TlsServerCertificate>> certs) {
        this.tlsClient = tlsClient;
        this.tlsClientProto = tlsClientProto;
        this.certs = certs;
    }

    public ClientCertTlsClient getTlsClient() {
        return this.tlsClient;
    }

    public TlsClientProtocol getTlsClientProto() {
        return this.tlsClientProto;
    }

    private void setStream(InputStream stream) {
        this.stream = stream;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void closeStream() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                LOG.debug("Failed to close stream.", ex);
            }
        }
        if (this.tlsClientProto != null) {
            try {
                this.tlsClientProto.close();
            }
            catch (IOException ex) {
                LOG.debug("Failed to close connection.", ex);
            }
        }
    }

    public List<Pair<URL, TlsServerCertificate>> getCerts() {
        return this.certs;
    }

    public synchronized String getData() throws IOException {
        if (this.data == null) {
            try {
                this.data = FileUtils.toString(this.stream);
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException ex) {
                        LOG.debug("Failed to close stream.", ex);
                    }
                }
            }
        }
        return this.data;
    }

    public static ResourceContext getStream(URL url) throws IOException, ResourceException, ValidationError, InvalidAddressException {
        return ResourceContext.getStream(url, new CertificateValidator(){

            @Override
            public CertificateValidator.VerifierResult validate(URL url, TlsServerCertificate cert) throws ValidationError {
                return CertificateValidator.VerifierResult.DONTCARE;
            }
        });
    }

    public static ResourceContext getStream(URL url, CertificateValidator v) throws IOException, ResourceException, ValidationError, InvalidAddressException {
        ArrayList<Pair<URL, TlsServerCertificate>> serverCerts = new ArrayList<Pair<URL, TlsServerCertificate>>();
        return ResourceContext.getStreamInt(url, v, serverCerts, 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceContext getStreamInt(URL url, CertificateValidator v, List<Pair<URL, TlsServerCertificate>> serverCerts, int maxRedirects) throws IOException, ResourceException, ValidationError, InvalidAddressException {
        try {
            String resource;
            DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
            CookieManager cManager = (CookieManager)dynCtx.get("cookie_mananger");
            LOG.info("Trying to load resource from: {}", (Object)url);
            if (maxRedirects == 0) {
                throw new ResourceException((I18nKey)ErrorTranslations.MAX_REDIRECTS, new Object[0]);
            }
            --maxRedirects;
            String protocol = url.getProtocol();
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            String string = resource = (resource = url.getFile()).isEmpty() ? "/" : resource;
            if (!"https".equals(protocol)) {
                throw new InvalidAddressException((I18nKey)ErrorTranslations.INVALID_ADDRESS, new Object[0]);
            }
            DynamicAuthentication tlsAuth = new DynamicAuthentication(hostname);
            if (ResourceContext.isPKIXVerify()) {
                tlsAuth.addCertificateVerifier(new JavaSecVerifier());
            }
            BcTlsCrypto crypto = new BcTlsCrypto(ReusableSecureRandom.getInstance());
            ClientCertDefaultTlsClient tlsClient = new ClientCertDefaultTlsClient((TlsCrypto)crypto, hostname, true);
            tlsClient.setAuthentication(tlsAuth);
            tlsClient.setClientVersion(ProtocolVersion.TLSv12);
            Socket socket = ProxySettings.getDefault().getSocket(protocol, hostname, port);
            TlsClientProtocol h = new TlsClientProtocol(socket.getInputStream(), socket.getOutputStream());
            LOG.debug("Performing TLS handshake.");
            h.connect(tlsClient);
            LOG.debug("TLS handshake performed.");
            serverCerts.add(new Pair<URL, TlsServerCertificate>(url, tlsAuth.getServerCertificate()));
            CertificateValidator.VerifierResult verifyResult = v.validate(url, tlsAuth.getServerCertificate());
            if (verifyResult == CertificateValidator.VerifierResult.FINISH) {
                List<Pair<URL, TlsServerCertificate>> pairs = Collections.unmodifiableList(serverCerts);
                return new ResourceContext(tlsClient, h, pairs);
            }
            StreamHttpClientConnection conn = new StreamHttpClientConnection(h.getInputStream(), h.getOutputStream());
            BasicHttpContext ctx = new BasicHttpContext();
            HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
            BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("GET", resource);
            HttpRequestHelper.setDefaultHeader((HttpRequest)req, url);
            req.setHeader("Accept", "text/xml, */*;q=0.8");
            req.setHeader("Accept-Charset", "utf-8, *;q=0.8");
            ResourceContext.setCookieHeader(req, cManager, url);
            HttpUtils.dumpHttpRequest(LOG, req);
            LOG.debug("Sending HTTP request.");
            HttpResponse response = httpexecutor.execute(req, conn, ctx);
            ResourceContext.storeCookies(response, cManager, url);
            LOG.debug("HTTP response received.");
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            String reason = status.getReasonPhrase();
            HttpUtils.dumpHttpResponse(LOG, response, null);
            HttpEntity entity = null;
            boolean finished = false;
            if (TR03112Utils.isRedirectStatusCode(statusCode)) {
                Header[] headers = response.getHeaders("Location");
                if (headers.length <= 0) throw new ResourceException((I18nKey)ErrorTranslations.MISSING_LOCATION_HEADER, new Object[0]);
                String uri = headers[0].getValue();
                url = new URL(uri);
            } else {
                if (statusCode >= 400) {
                    LOG.debug("Received a result code {} '{}' from server.", (Object)statusCode, (Object)reason);
                    throw new InvalidResultStatus(LANG.translationForKey(ErrorTranslations.INVALID_RESULT_STATUS, statusCode, reason));
                }
                if (verifyResult == CertificateValidator.VerifierResult.CONTINUE) {
                    throw new InvalidAddressException((I18nKey)ErrorTranslations.INVALID_REFRESH_ADDRESS_NOSOP, new Object[0]);
                }
                conn.receiveResponseEntity(response);
                entity = response.getEntity();
                finished = true;
            }
            if (finished) {
                assert (entity != null);
                ResourceContext result = new ResourceContext(tlsClient, h, serverCerts);
                LimitedInputStream is = new LimitedInputStream(entity.getContent());
                result.setStream(is);
                return result;
            }
            h.close();
            return ResourceContext.getStreamInt(url, v, serverCerts, maxRedirects);
        }
        catch (URISyntaxException ex) {
            throw new IOException(LANG.translationForKey(ErrorTranslations.FAILED_PROXY, new Object[0]), ex);
        }
        catch (HttpException ex) {
            throw new IOException("Invalid HTTP message received.", ex);
        }
    }

    @Nullable
    private static String setCookieHeader(@Nonnull BasicHttpRequest req, CookieManager manager, @Nonnull URL url) {
        String cookieHeader = null;
        try {
            if (manager != null && (cookieHeader = manager.getCookieHeaderValue(url.toString())) != null && !cookieHeader.isEmpty()) {
                req.setHeader("Cookie", cookieHeader);
            }
        }
        catch (CookieException cookieException) {
            // empty catch block
        }
        return cookieHeader;
    }

    private static void storeCookies(@Nonnull HttpResponse response, CookieManager cManager, @Nonnull URL url) {
        Header[] headers;
        for (Header header : headers = response.getAllHeaders()) {
            if (!header.getName().toLowerCase().equals("set-cookie")) continue;
            try {
                if (cManager == null) continue;
                cManager.addCookie(url.toString(), header.getValue());
            }
            catch (CookieException ex) {
                String msg = "Received invalid cookie from: %s. The cookie is not stored.";
                msg = String.format(msg, url.toString());
                LOG.warn(msg, ex);
            }
        }
    }

    private static boolean isPKIXVerify() {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        Promise<Object> cardTypeP = dynCtx.getPromise("activation_card_type");
        Object cardType = cardTypeP.derefNonblocking();
        return cardType != null && !"http://bsi.bund.de/cif/npa.xml".equals(cardType);
    }
}

