/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOS;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.Callable;
import org.openecard.binding.tctoken.ConnectionError;
import org.openecard.binding.tctoken.TCTokenHandler;
import org.openecard.binding.tctoken.TCTokenRequest;
import org.openecard.binding.tctoken.TlsConnectionHandler;
import org.openecard.common.AppVersion;
import org.openecard.common.ECardConstants;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.gui.UserConsent;
import org.openecard.transport.paos.PAOS;
import org.openecard.transport.paos.PAOSConnectionException;
import org.openecard.transport.paos.PAOSException;

public class PAOSTask
implements Callable<StartPAOSResponse> {
    private final Dispatcher dispatcher;
    private final ConnectionHandleType connectionHandle;
    private final List<String> supportedDIDs;
    private final TCTokenRequest tokenRequest;
    private final UserConsent gui;

    public PAOSTask(Dispatcher dispatcher, ConnectionHandleType connectionHandle, List<String> supportedDIDs, TCTokenRequest tokenRequest, UserConsent gui) {
        this.dispatcher = dispatcher;
        this.connectionHandle = connectionHandle;
        this.supportedDIDs = supportedDIDs;
        this.tokenRequest = tokenRequest;
        this.gui = gui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPAOSResponse call() throws MalformedURLException, PAOSException, DispatcherException, InvocationTargetException, ConnectionError, PAOSConnectionException {
        try {
            TlsConnectionHandler tlsHandler = new TlsConnectionHandler(this.dispatcher, this.tokenRequest, this.connectionHandle);
            tlsHandler.setUpClient();
            PAOS p = new PAOS(this.dispatcher, tlsHandler);
            StartPAOS sp = new StartPAOS();
            sp.setProfile("http://www.bsi.bund.de/ecard/api/1.1");
            sp.getConnectionHandle().add(this.connectionHandle);
            sp.setSessionIdentifier(tlsHandler.getSessionId());
            StartPAOS.UserAgent ua = new StartPAOS.UserAgent();
            ua.setName(AppVersion.getName());
            ua.setVersionMajor(BigInteger.valueOf(AppVersion.getMajor()));
            ua.setVersionMinor(BigInteger.valueOf(AppVersion.getMinor()));
            ua.setVersionSubminor(BigInteger.valueOf(AppVersion.getPatch()));
            sp.setUserAgent(ua);
            StartPAOS.SupportedAPIVersions sv = new StartPAOS.SupportedAPIVersions();
            sv.setMajor(ECardConstants.ECARD_API_VERSION_MAJOR);
            sv.setMinor(ECardConstants.ECARD_API_VERSION_MINOR);
            sv.setSubminor(ECardConstants.ECARD_API_VERSION_SUBMINOR);
            sp.getSupportedAPIVersions().add(sv);
            sp.getSupportedDIDProtocols().addAll(this.supportedDIDs);
            StartPAOSResponse startPAOSResponse = p.sendStartPAOS(sp);
            return startPAOSResponse;
        }
        finally {
            TCTokenHandler.disconnectHandle(this.dispatcher, this.connectionHandle);
            TCTokenHandler.killUserConsent();
        }
    }
}

