/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.StartPAOSResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.impl.DefaultConnectionReuseStrategy;
import org.openecard.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestExecutor;
import org.openecard.binding.tctoken.ConnectionError;
import org.openecard.binding.tctoken.TCTokenHandler;
import org.openecard.binding.tctoken.TCTokenRequest;
import org.openecard.binding.tctoken.TlsConnectionHandler;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.common.I18nKey;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.FileUtils;
import org.openecard.transport.httpcore.HttpRequestHelper;
import org.openecard.transport.httpcore.HttpUtils;
import org.openecard.transport.httpcore.StreamHttpClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetTask
implements Callable<StartPAOSResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpGetTask.class);
    private final Dispatcher dispatcher;
    private final ConnectionHandleType connectionHandle;
    private final TCTokenRequest tokenRequest;

    public HttpGetTask(Dispatcher dispatcher, ConnectionHandleType connectionHandle, TCTokenRequest tokenRequest) {
        this.dispatcher = dispatcher;
        this.connectionHandle = connectionHandle;
        this.tokenRequest = tokenRequest;
    }

    @Override
    public StartPAOSResponse call() throws Exception {
        try {
            this.getRequest();
        }
        finally {
            TCTokenHandler.disconnectHandle(this.dispatcher, this.connectionHandle);
            TCTokenHandler.killUserConsent();
        }
        StartPAOSResponse response = (StartPAOSResponse)WSHelper.makeResponse(StartPAOSResponse.class, WSHelper.makeResultOK());
        return response;
    }

    private void getRequest() throws IOException, ConnectionError, URISyntaxException, HttpException {
        TlsConnectionHandler tlsHandler = new TlsConnectionHandler(this.dispatcher, this.tokenRequest, this.connectionHandle);
        tlsHandler.setUpClient();
        TlsClientProtocol handler = tlsHandler.createTlsConnection();
        InputStream in = handler.getInputStream();
        OutputStream out = handler.getOutputStream();
        StreamHttpClientConnection conn = new StreamHttpClientConnection(in, out);
        BasicHttpContext ctx = new BasicHttpContext();
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        DefaultConnectionReuseStrategy reuse = new DefaultConnectionReuseStrategy();
        String resource = tlsHandler.getResource();
        BasicHttpEntityEnclosingRequest req = new BasicHttpEntityEnclosingRequest("GET", resource);
        HttpRequestHelper.setDefaultHeader((HttpRequest)req, tlsHandler.getServerAddress());
        req.setHeader("Accept", "text/html, */*;q=0.8");
        req.setHeader("Accept-Charset", "utf-8, *;q=0.8");
        HttpUtils.dumpHttpRequest(LOG, req);
        HttpResponse response = httpexecutor.execute(req, conn, ctx);
        int statusCode = response.getStatusLine().getStatusCode();
        conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        byte[] entityData = FileUtils.toByteArray(entity.getContent());
        HttpUtils.dumpHttpResponse(LOG, response, entityData);
        conn.close();
        if (statusCode < 200 || statusCode > 299) {
            throw new ConnectionError((I18nKey)ErrorTranslations.WRONG_SERVER_RESULT, statusCode);
        }
    }
}

