/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon.sal;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialManager {
    private static final Logger logger = LoggerFactory.getLogger(CredentialManager.class);
    private final CardStateMap states;

    public CredentialManager(CardStateMap states) {
        this.states = states;
    }

    public boolean addCredential(ConnectionHandleType handle, String protocol, CardInfoType cif) {
        if (handle == null || cif == null) {
            logger.warn("The ConnectionHandle and/or CardInfo object is null. Can't add the Credential.");
            return false;
        }
        CardStateEntry entry = new CardStateEntry(handle, cif, protocol);
        this.states.addEntry(entry);
        return true;
    }

    public boolean removeCredential(ConnectionHandleType handle) {
        if (handle == null) {
            logger.warn("The ConnectionHandle is null. Can't remove the requested Credential.");
            return false;
        }
        this.states.removeEntry(handle);
        return true;
    }
}

