/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.ws.marshal.MarshallingTypeException;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ManifestExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ManifestExtractor.class);
    private static final String MANIFEST_XML = "META-INF/addon.xml";
    private final WSMarshaller marshaller = WSMarshallerFactory.createInstance();

    public ManifestExtractor() throws MarshallingTypeException, WSMarshallerException {
        this.marshaller.removeAllTypeClasses();
        this.marshaller.addXmlTypeClass(AddonSpecification.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddonSpecification getAddonSpecificationFromFile(File file) {
        AddonSpecification abd;
        JarFile jarFile;
        String name = file.getName();
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            logger.debug("File {} will not be registered as plugin because it's not a JarFile.", (Object)name);
            return null;
        }
        try {
            InputStream manifestStream = this.getPluginEntryClass(jarFile);
            if (manifestStream == null) {
                logger.debug("File {} will not be registered as plugin because it doesn't contain a addon.xml.", (Object)name);
                AddonSpecification addonSpecification = null;
                return addonSpecification;
            }
            this.marshaller.addXmlTypeClass(AddonSpecification.class);
            Document manifestDoc = this.marshaller.str2doc(manifestStream);
            abd = (AddonSpecification)this.marshaller.unmarshal(manifestDoc);
        }
        catch (IOException | WSMarshallerException | SAXException ex) {
            logger.error("Failed to process addon.xml entry for file " + name + ".", ex);
            AddonSpecification addonSpecification = null;
            return addonSpecification;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException ex) {
                logger.error("Failed to close jar file.", ex);
            }
        }
        return abd;
    }

    private InputStream getPluginEntryClass(JarFile jarFile) throws IOException {
        ZipEntry manifest = jarFile.getEntry(MANIFEST_XML);
        if (manifest == null) {
            return null;
        }
        return jarFile.getInputStream(manifest);
    }
}

