/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.util.Set;
import org.openecard.addon.AddonException;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.ClasspathRegistry;
import org.openecard.addon.FileRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.ws.marshal.WSMarshallerException;

public class CombiningRegistry
implements AddonRegistry {
    private final ClasspathRegistry classpathRegistry = new ClasspathRegistry();
    private final FileRegistry fileRegistry;

    public CombiningRegistry(AddonManager manager) throws WSMarshallerException {
        this.fileRegistry = new FileRegistry(manager);
    }

    public ClasspathRegistry getClasspathRegistry() {
        return this.classpathRegistry;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    @Override
    public Set<AddonSpecification> listAddons() {
        Set<AddonSpecification> list = this.classpathRegistry.listAddons();
        list.addAll(this.fileRegistry.listAddons());
        return list;
    }

    @Override
    public AddonSpecification search(String id) {
        AddonSpecification desc = this.classpathRegistry.search(id);
        if (desc == null) {
            desc = this.fileRegistry.search(id);
        }
        return desc;
    }

    @Override
    public Set<AddonSpecification> searchByName(String name) {
        Set<AddonSpecification> searchByName = this.classpathRegistry.searchByName(name);
        if (searchByName.isEmpty()) {
            searchByName = this.fileRegistry.searchByName(name);
        }
        return searchByName;
    }

    @Override
    public Set<AddonSpecification> searchIFDProtocol(String uri) {
        Set<AddonSpecification> matchingAddons = this.classpathRegistry.searchIFDProtocol(uri);
        if (matchingAddons.isEmpty()) {
            matchingAddons = this.fileRegistry.searchIFDProtocol(uri);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchSALProtocol(String uri) {
        Set<AddonSpecification> matchingAddons = this.classpathRegistry.searchSALProtocol(uri);
        if (matchingAddons.isEmpty()) {
            matchingAddons = this.fileRegistry.searchSALProtocol(uri);
        }
        return matchingAddons;
    }

    @Override
    public ClassLoader downloadAddon(AddonSpecification addonSpec) throws AddonException {
        AddonSpecification desc = this.classpathRegistry.search(addonSpec.getId());
        if (desc != null) {
            return this.classpathRegistry.downloadAddon(addonSpec);
        }
        return this.fileRegistry.downloadAddon(addonSpec);
    }

    @Override
    public Set<AddonSpecification> searchByResourceName(String resourceName) {
        Set<AddonSpecification> matchingAddons = this.classpathRegistry.searchByResourceName(resourceName);
        if (matchingAddons.isEmpty()) {
            matchingAddons = this.fileRegistry.searchByResourceName(resourceName);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchByActionId(String actionId) {
        Set<AddonSpecification> matchingAddons = this.classpathRegistry.searchByActionId(actionId);
        if (matchingAddons.isEmpty()) {
            matchingAddons = this.fileRegistry.searchByResourceName(actionId);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> listInstalledAddons() {
        Set<AddonSpecification> addons = this.fileRegistry.listInstalledAddons();
        addons.addAll(this.classpathRegistry.listInstalledAddons());
        return addons;
    }
}

