/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openecard.addon.AddonRegistry;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.manifest.AppExtensionSpecification;
import org.openecard.addon.manifest.AppPluginSpecification;
import org.openecard.addon.manifest.LocalizedString;
import org.openecard.addon.manifest.ProtocolPluginSpecification;
import org.openecard.common.util.FileUtils;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ClasspathRegistry
implements AddonRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathRegistry.class);
    private final FutureTask<ArrayList<AddonSpecification>> registeredAddons = new FutureTask<ArrayList<AddonSpecification>>(new Callable<ArrayList<AddonSpecification>>(){

        @Override
        public ArrayList<AddonSpecification> call() throws Exception {
            ArrayList<AddonSpecification> addons = new ArrayList<AddonSpecification>();
            WSMarshaller marshaller = WSMarshallerFactory.createInstance();
            marshaller.removeAllTypeClasses();
            marshaller.addXmlTypeClass(AddonSpecification.class);
            ClasspathRegistry.this.loadManifest(addons, marshaller, "TR-03112", "TCToken-Manifest.xml");
            ClasspathRegistry.this.loadManifest(addons, marshaller, "ChipGateway", "ChipGateway-Manifest.xml");
            ClasspathRegistry.this.loadManifest(addons, marshaller, "PIN-Management", "PIN-Plugin-Manifest.xml");
            ClasspathRegistry.this.loadManifest(addons, marshaller, "GenericCrypto", "GenericCrypto-Plugin-Manifest.xml");
            ClasspathRegistry.this.loadManifest(addons, marshaller, "Status", "Status-Plugin-Manifest.xml");
            ClasspathRegistry.this.loadManifest(addons, marshaller, "PKCS#11", "PKCS11-Manifest.xml");
            return addons;
        }
    });

    public ClasspathRegistry() {
        new Thread(this.registeredAddons, "Init-Classpath-Addons").start();
    }

    private void loadManifest(ArrayList<AddonSpecification> addons, WSMarshaller m, String addonName, String fileName) {
        try {
            InputStream manifestStream = FileUtils.resolveResourceAsStream(ClasspathRegistry.class, fileName);
            if (manifestStream == null) {
                LOG.warn("Skipped loading internal add-on {}, because it is not available.", (Object)addonName);
                return;
            }
            Document manifestDoc = m.str2doc(manifestStream);
            this.registerInt(addons, (AddonSpecification)m.unmarshal(manifestDoc));
            LOG.info("Loaded internal {} add-on.", (Object)addonName);
        }
        catch (IOException ex) {
            LOG.warn(String.format("Failed to load internal %s add-on.", addonName), ex);
        }
        catch (SAXException ex) {
            LOG.warn(String.format("Failed to load internal %s add-on.", addonName), ex);
        }
        catch (WSMarshallerException ex) {
            LOG.warn(String.format("Failed to load internal %s add-on.", addonName), ex);
        }
    }

    private ArrayList<AddonSpecification> getAddons() {
        try {
            return this.registeredAddons.get();
        }
        catch (InterruptedException ex) {
            String msg = "Initialization of the built-in Add-ons has been interrupted.";
            LOG.warn(msg);
            throw new RuntimeException(msg);
        }
        catch (ExecutionException ex) {
            String msg = "Initialization of the built-in Add-ons yielded an error.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg, ex.getCause());
        }
    }

    private void registerInt(ArrayList<AddonSpecification> registeredAddons, AddonSpecification desc) {
        registeredAddons.add(desc);
    }

    public final void register(AddonSpecification desc) {
        this.registerInt(this.getAddons(), desc);
    }

    @Override
    public Set<AddonSpecification> listAddons() {
        HashSet<AddonSpecification> list = new HashSet<AddonSpecification>();
        list.addAll(this.getAddons());
        return list;
    }

    @Override
    public AddonSpecification search(String id) {
        for (AddonSpecification desc : this.getAddons()) {
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    @Override
    public Set<AddonSpecification> searchByName(String name) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons()) {
            for (LocalizedString s : desc.getLocalizedName()) {
                if (!s.getValue().equals(name)) continue;
                matchingAddons.add(desc);
            }
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchIFDProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons()) {
            ProtocolPluginSpecification protocolDesc = desc.searchIFDActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchSALProtocol(String uri) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons()) {
            ProtocolPluginSpecification protocolDesc = desc.searchSALActionByURI(uri);
            if (protocolDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public ClassLoader downloadAddon(AddonSpecification addonSpec) {
        return this.getClass().getClassLoader();
    }

    @Override
    public Set<AddonSpecification> searchByResourceName(String resourceName) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons()) {
            AppPluginSpecification actionDesc = desc.searchByResourceName(resourceName);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> searchByActionId(String actionId) {
        HashSet<AddonSpecification> matchingAddons = new HashSet<AddonSpecification>();
        for (AddonSpecification desc : this.getAddons()) {
            AppExtensionSpecification actionDesc = desc.searchByActionId(actionId);
            if (actionDesc == null) continue;
            matchingAddons.add(desc);
        }
        return matchingAddons;
    }

    @Override
    public Set<AddonSpecification> listInstalledAddons() {
        return this.listAddons();
    }
}

