/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.addon;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import org.openecard.addon.bind.AppExtensionAction;
import org.openecard.addon.bind.AppPluginAction;
import org.openecard.addon.ifd.IFDProtocol;
import org.openecard.addon.manifest.AddonSpecification;
import org.openecard.addon.sal.SALProtocol;

public class Cache {
    private final TreeMap<AddonSpecification, TreeMap<String, Object>> addonSpecAndId = new TreeMap();

    public void addSALProtocol(AddonSpecification spec, String uri, SALProtocol protocol) {
        this.addEntry(spec, uri, protocol);
    }

    public void addIFDProtocol(AddonSpecification spec, String uri, IFDProtocol protocol) {
        this.addEntry(spec, uri, protocol);
    }

    public void addAppExtensionAction(AddonSpecification spec, String actionId, AppExtensionAction action) {
        this.addEntry(spec, actionId, action);
    }

    public void addAppPluginAction(AddonSpecification spec, String resourceId, AppPluginAction action) {
        this.addEntry(spec, resourceId, action);
    }

    private void addEntry(AddonSpecification spec, String id, Object protocolOrAction) {
        TreeMap<String, Object> protocols = this.addonSpecAndId.get(spec);
        if (protocols == null) {
            protocols = new TreeMap();
        }
        protocols.put(id, protocolOrAction);
        this.addonSpecAndId.put(spec, protocols);
    }

    public IFDProtocol getIFDProtocol(AddonSpecification spec, String uri) {
        Object protocolObject = this.getObject(spec, uri);
        if (protocolObject == null || !(protocolObject instanceof IFDProtocol)) {
            return null;
        }
        return (IFDProtocol)protocolObject;
    }

    public SALProtocol getSALProtocol(AddonSpecification spec, String uri) {
        Object protocolObject = this.getObject(spec, uri);
        if (protocolObject == null || !(protocolObject instanceof SALProtocol)) {
            return null;
        }
        return (SALProtocol)protocolObject;
    }

    public AppExtensionAction getAppExtensionAction(AddonSpecification spec, String actionId) {
        Object protocolObject = this.getObject(spec, actionId);
        if (protocolObject == null || !(protocolObject instanceof AppExtensionAction)) {
            return null;
        }
        return (AppExtensionAction)protocolObject;
    }

    public AppPluginAction getAppPluginAction(AddonSpecification spec, String resourceName) {
        Object protocolObject = this.getObject(spec, resourceName);
        if (protocolObject == null || !(protocolObject instanceof AppPluginAction)) {
            return null;
        }
        return (AppPluginAction)protocolObject;
    }

    private Object getObject(AddonSpecification spec, String id) {
        TreeMap<String, Object> protocols = this.addonSpecAndId.get(spec);
        if (protocols == null) {
            return null;
        }
        return protocols.get(id);
    }

    protected Collection<Object> getAllAddonData(AddonSpecification spec) {
        TreeMap<String, Object> data = this.addonSpecAndId.get(spec);
        if (data != null) {
            return data.values();
        }
        return Collections.EMPTY_LIST;
    }

    public void removeCacheEntry(AddonSpecification spec, String id) {
        TreeMap<String, Object> protocols = this.addonSpecAndId.get(spec);
        protocols.remove(id);
    }

    public void removeCompleteAddonCache(AddonSpecification spec) {
        this.addonSpecAndId.remove(spec);
    }
}

