/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.soap;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.openecard.ws.soap.MessageFactory;
import org.openecard.ws.soap.SOAPBody;
import org.openecard.ws.soap.SOAPEnvelope;
import org.openecard.ws.soap.SOAPException;
import org.openecard.ws.soap.SOAPHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPMessage {
    private final Document doc;
    private final String namespace;
    private final SOAPEnvelope env;
    private final SOAPHeader head;
    private final SOAPBody body;

    protected SOAPMessage(DocumentBuilder docBuilder, String namespace) throws SOAPException {
        this.doc = docBuilder.newDocument();
        this.namespace = namespace;
        Element envElem = this.doc.createElementNS(namespace, "Envelope");
        this.env = new SOAPEnvelope(envElem);
        this.doc.appendChild(envElem);
        Element headElem = this.env.addChildElement(new QName(namespace, "Header"));
        this.head = new SOAPHeader(headElem);
        Element bodyElem = this.env.addChildElement(new QName(namespace, "Body"));
        this.body = new SOAPBody(bodyElem);
    }

    protected SOAPMessage(Document doc) throws SOAPException {
        this.doc = doc;
        Element envElem = (Element)doc.getFirstChild();
        if (envElem == null) {
            throw new SOAPException("No Envelope element in SOAP message.");
        }
        this.env = new SOAPEnvelope(envElem);
        this.namespace = MessageFactory.verifyNamespace(envElem.getNamespaceURI());
        boolean headProcessed = false;
        Element headElem = null;
        boolean bodyProcessed = false;
        Element bodyElem = null;
        NodeList nodes = envElem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                if (e.getNamespaceURI().equals(this.namespace)) {
                    if (!headProcessed && !bodyProcessed && "Header".equals(e.getLocalName())) {
                        headProcessed = true;
                        headElem = e;
                        continue;
                    }
                    if (!bodyProcessed && "Body".equals(e.getLocalName())) {
                        bodyProcessed = true;
                        bodyElem = e;
                        continue;
                    }
                    throw new SOAPException("Undefined element (" + e.getLocalName() + ") in SOAP message.");
                }
                throw new SOAPException("Undefined namespace (" + e.getNamespaceURI() + ") in SOAP message.");
            }
            if (n.getNodeType() != 3 && n.getNodeType() != 4) continue;
            System.out.println("Undefined node type in SOAP message: " + n.getNodeType() + n.getNodeName() + n.getNodeValue() + n.getTextContent());
        }
        if (!bodyProcessed) {
            throw new SOAPException("No Body element present in SOAP message.");
        }
        if (!headProcessed) {
            headElem = doc.createElementNS(this.namespace, "Header");
            headElem = (Element)envElem.insertBefore(headElem, bodyElem);
        }
        this.head = new SOAPHeader(headElem);
        this.body = new SOAPBody(bodyElem);
    }

    public Document getDocument() {
        return this.doc;
    }

    public SOAPEnvelope getSOAPEnvelope() {
        return this.env;
    }

    public SOAPHeader getSOAPHeader() {
        return this.head;
    }

    public SOAPBody getSOAPBody() {
        return this.body;
    }
}

