/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlType;
import org.openecard.ws.jaxb.ClassComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(MarshallerImpl.class);
    private static final ArrayList<Class<?>> baseXmlElementClasses;
    private static final FutureTask<JAXBContext> baseJaxbContext;
    private static final HashMap<String, JAXBContext> specificContexts;
    private boolean userOverride = false;
    private final TreeSet<Class<?>> userClasses = new TreeSet(new ClassComparator());
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public synchronized void addXmlClass(Class<?> c) {
        this.addBaseClasses();
        if (!this.userClasses.contains(c)) {
            this.userClasses.add(c);
            this.userOverride = true;
            this.resetMarshaller();
        }
    }

    private void addBaseClasses() {
        if (!this.userOverride) {
            this.userClasses.addAll(baseXmlElementClasses);
        }
    }

    public synchronized void removeAllClasses() {
        this.userOverride = true;
        this.userClasses.clear();
        this.resetMarshaller();
    }

    public Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.loadInstances();
        }
        return this.marshaller;
    }

    public Unmarshaller getUnmarshaller() throws JAXBException {
        if (this.unmarshaller == null) {
            this.loadInstances();
        }
        return this.unmarshaller;
    }

    private void resetMarshaller() {
        this.marshaller = null;
        this.unmarshaller = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadInstances() throws JAXBException {
        JAXBContext jaxbCtx;
        if (this.userOverride) {
            String classHash = this.calculateClassesHash();
            HashMap<String, JAXBContext> hashMap = specificContexts;
            synchronized (hashMap) {
                if (!specificContexts.containsKey(classHash)) {
                    jaxbCtx = JAXBContext.newInstance((Class[])this.userClasses.toArray(new Class[this.userClasses.size()]));
                    specificContexts.put(classHash, jaxbCtx);
                } else {
                    jaxbCtx = specificContexts.get(classHash);
                }
            }
        }
        try {
            jaxbCtx = baseJaxbContext.get();
        }
        catch (ExecutionException ex) {
            LOG.error("Failed to create JAXBContext instance.", ex);
            throw new RuntimeException("Failed to create JAXBContext.");
        }
        catch (InterruptedException ex) {
            LOG.error("Thread terminated waiting for the JAXBContext to be created..", ex);
            throw new RuntimeException("Thread interrupted during waiting on the creation of the JAXBContext.");
        }
        this.marshaller = jaxbCtx.createMarshaller();
        this.unmarshaller = jaxbCtx.createUnmarshaller();
    }

    private static Class<?>[] getJaxbClasses() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        LinkedList classes = new LinkedList();
        InputStream classListStream = cl.getResourceAsStream("classes.lst");
        InputStream classListStreamC = cl.getResourceAsStream("/classes.lst");
        try {
            String next;
            if (classListStream == null && classListStreamC == null) {
                throw new IOException("Failed to load classes.lst.");
            }
            classListStream = classListStream != null ? classListStream : classListStreamC;
            LineNumberReader r = new LineNumberReader(new InputStreamReader(classListStream));
            while ((next = r.readLine()) != null) {
                try {
                    Class<?> c = cl.loadClass(next);
                    if (!MarshallerImpl.isJaxbClass(c)) continue;
                    classes.add(c);
                }
                catch (ClassNotFoundException ex) {
                    LOG.error("Failed to load class: " + next, ex);
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to read classes from file classes.lst.", ex);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static boolean isJaxbClass(Class<?> c) {
        return c.isAnnotationPresent(XmlType.class) || c.isAnnotationPresent(XmlRegistry.class);
    }

    private String calculateClassesHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (Class<?> c : this.userClasses) {
                md.update(c.getName().getBytes());
            }
            byte[] digest = md.digest();
            return MarshallerImpl.toHexString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("MD5 hash algorithm is not supported on your platform.", ex);
        }
    }

    private static String toHexString(@Nonnull byte[] bytes) {
        StringWriter writer = new StringWriter(bytes.length * 2);
        PrintWriter out = new PrintWriter(writer);
        for (int i = 1; i <= bytes.length; ++i) {
            out.printf("%02X", bytes[i - 1]);
        }
        return writer.toString();
    }

    static {
        final Class[] jaxbClasses = MarshallerImpl.getJaxbClasses();
        baseXmlElementClasses = new ArrayList(jaxbClasses.length);
        baseXmlElementClasses.addAll(Arrays.asList(jaxbClasses));
        baseJaxbContext = new FutureTask<JAXBContext>(new Callable<JAXBContext>(){

            @Override
            public JAXBContext call() throws Exception {
                try {
                    return JAXBContext.newInstance((Class[])jaxbClasses);
                }
                catch (JAXBException ex) {
                    LOG.error("Failed to create JAXBContext instance.", ex);
                    throw new RuntimeException("Failed to create JAXBContext.");
                }
            }
        });
        new Thread(baseJaxbContext, "JAXB-Classload").start();
        specificContexts = new HashMap();
    }
}

