/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ws.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.openecard.ws.common.GenericFactoryException;

public class GenericFactory<T> {
    private final Class<T> typeClass;
    private final Class<? extends T> actualClass;
    private final Constructor<? extends T> constructor;

    public GenericFactory(Class<T> typeClass, Properties properties, String key) throws GenericFactoryException {
        this.typeClass = typeClass;
        String className = properties.getProperty(key);
        if (className == null) {
            throw new GenericFactoryException("No factory class defined for the specified key '" + key + "'.");
        }
        try {
            this.actualClass = this.loadClass(className);
            this.constructor = this.getConstructor(this.actualClass);
        }
        catch (ClassNotFoundException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new GenericFactoryException(ex);
        }
    }

    public T getInstance() throws GenericFactoryException {
        try {
            T o = this.constructor.newInstance(new Object[0]);
            return o;
        }
        catch (InstantiationException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new GenericFactoryException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new GenericFactoryException(ex);
        }
    }

    private Constructor<? extends T> getConstructor(Class<? extends T> clazz) throws GenericFactoryException, NoSuchMethodException {
        Constructor<T> m = clazz.getConstructor(new Class[0]);
        if (Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        String msg = String.format("Constructor of class %s is not publicly available.", clazz.getName());
        throw new GenericFactoryException(msg);
    }

    private Class<? extends T> loadClass(String className) throws ClassNotFoundException, GenericFactoryException {
        Class<?> c = Class.forName(className);
        try {
            Class<T> c2 = c.asSubclass(this.typeClass);
            return c2;
        }
        catch (ClassCastException ex) {
            String msg = String.format("Referenced class %s is not a compatible subtype for this factory.", c.getName());
            throw new GenericFactoryException(msg);
        }
    }
}

