/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.httpcore.cookies;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import org.openecard.transport.httpcore.cookies.CookieException;

public class Cookie {
    private final String name;
    private final String value;
    private long creationTime;
    private boolean httpOnly;
    private boolean secure;
    private Date expires;
    private long maxAge = -1L;
    private String domain = "";
    private String path = "";

    public Cookie(@Nonnull String cookieName, @Nonnull String cookieValue) {
        if (cookieName == null) {
            throw new NullPointerException("NULL value not allowed for the cookie name.");
        }
        if (cookieValue == null) {
            throw new NullPointerException("NULL value not allowed for the cookie value");
        }
        this.name = cookieName;
        this.value = cookieValue;
        this.creationTime = System.currentTimeMillis();
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setSecure(boolean isSecure) {
        this.secure = isSecure;
    }

    public void setExpires(@Nonnull String dateString) throws CookieException {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
        try {
            this.expires = format.parse(dateString);
        }
        catch (ParseException ex) {
            throw new CookieException("The date string has a wrong format and can not be parsed.", ex);
        }
    }

    public void setMaxAge(@Nonnull String maxAgeSeconds) {
        long lifeTimeMilliSeconds = Long.parseLong(maxAgeSeconds) * 1000L;
        this.maxAge = this.creationTime + lifeTimeMilliSeconds;
    }

    public void setDomain(@Nonnull String domain) {
        this.domain = domain;
    }

    public void setPath(@Nonnull String path) {
        this.path = path;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public String getDomain() {
        return this.domain;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isExpired() {
        if (this.maxAge != -1L || this.expires != null) {
            if (this.maxAge != -1L) {
                return this.maxAge <= System.currentTimeMillis();
            }
            if (this.expires != null) {
                Date now = new Date(System.currentTimeMillis());
                return now.after(this.expires);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie c = (Cookie)o;
        return c.getName().equals(this.name) && c.getDomain().equals(this.domain) && c.getPath().equals(this.path) && c.getValue().equals(this.value);
    }

    public int hashCode() {
        int hash = this.name.hashCode() + this.value.hashCode() + this.domain.hashCode() + this.path.hashCode();
        return hash;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

