/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.dispatcher;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.jws.WebMethod;
import javax.xml.transform.TransformerException;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.interfaces.Publish;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Service
implements Comparable<Service> {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private final Class<?> iface;
    private final Class<?> impl;
    private final ArrayList<Class<?>> requestClasses;
    private final TreeMap<String, Method> requestMethods;
    private final HashMap<Class<?>, MessageLogger> objectLoggers;
    private final List<String> actions;
    private final boolean isFilter;

    public Service(Class<?> iface, Class<?> impl) {
        this(iface, impl, false);
    }

    protected Service(Class<?> iface, Class<?> impl, boolean isFilter) {
        this.iface = iface;
        this.impl = impl;
        this.requestClasses = new ArrayList();
        this.requestMethods = new TreeMap();
        this.objectLoggers = new HashMap();
        this.actions = new ArrayList<String>();
        this.isFilter = isFilter;
        this.init();
    }

    private void init() {
        Method[] methods;
        for (Method m : methods = this.impl.getDeclaredMethods()) {
            WebMethod webAnnotation = Service.getAnnotation(m, WebMethod.class);
            if (!this.isReqParam(m) || webAnnotation == null) continue;
            Class<?> reqClass = this.getReqParamClass(m);
            if (this.requestMethods.containsKey(reqClass.getName())) {
                String msg = "Omitting method {} in service interface {}, because its parameter type is ";
                msg = msg + "already associated with another method.";
                logger.warn(msg, (Object)m.getName(), (Object)this.impl.getName());
                continue;
            }
            String action = webAnnotation.action();
            if (this.isFilter) {
                if (Service.getAnnotation(m, Publish.class) == null) continue;
                this.requestClasses.add(reqClass);
                this.requestMethods.put(reqClass.getName(), m);
                this.actions.add(action);
                continue;
            }
            this.requestClasses.add(reqClass);
            this.requestMethods.put(reqClass.getName(), m);
            this.actions.add(action);
        }
    }

    private static <A extends Annotation> A getAnnotation(Method m, Class<? extends A> aClass) {
        A a = m.getAnnotation(aClass);
        if (a != null) {
            return a;
        }
        ArrayList children = new ArrayList();
        Class<?> declaringClass = m.getDeclaringClass();
        children.addAll(Arrays.asList(declaringClass.getInterfaces()));
        if (declaringClass.getSuperclass() != null) {
            children.add(declaringClass.getSuperclass());
        }
        for (Class clazz : children) {
            try {
                m = clazz.getDeclaredMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException ex) {
                continue;
            }
            a = Service.getAnnotation(m, aClass);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public Class<?> getServiceInterface() {
        return this.iface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageLogger getLogger(Object ifaceImpl) {
        Class<?> implClass = ifaceImpl.getClass();
        if (this.objectLoggers.containsKey(implClass)) {
            return this.objectLoggers.get(implClass);
        }
        Service service = this;
        synchronized (service) {
            MessageLogger implLogger = new MessageLogger(ifaceImpl.getClass());
            this.objectLoggers.put(implClass, implLogger);
            return implLogger;
        }
    }

    public Object invoke(Object ifaceImpl, Object req) throws DispatcherException, InvocationTargetException {
        try {
            MessageLogger l = this.getLogger(ifaceImpl);
            Class<?> reqClass = req.getClass();
            Method m = this.getMethod(reqClass.getName());
            l.logRequest(req);
            Object res = m.invoke(ifaceImpl, req);
            l.logResponse(res);
            return res;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException ex) {
            throw new DispatcherException(ex);
        }
    }

    private Class<?> getReqParamClass(Method m) {
        Class<?>[] params = m.getParameterTypes();
        if (params.length != 1) {
            return null;
        }
        return params[0];
    }

    private boolean isReqParam(Method m) {
        return this.getReqParamClass(m) != null;
    }

    public List<Class<?>> getRequestClasses() {
        return Collections.unmodifiableList(this.requestClasses);
    }

    private Method getMethod(String paramClass) throws NoSuchMethodException {
        Method m = this.requestMethods.get(paramClass);
        if (m == null) {
            String msg = "Method containing parameter with class '" + paramClass + "' does not exist in interface '";
            msg = msg + this.iface.getName() + "'.";
            throw new NoSuchMethodException(msg);
        }
        return m;
    }

    protected List<String> getActionList() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public int compareTo(Service o) {
        return this.iface.toString().compareTo(o.iface.toString());
    }

    private class MessageLogger {
        private final Logger l;
        private final String reqLogMsg;
        private final String resLogMsg;

        public MessageLogger(Class<?> receiverClass) {
            this.l = LoggerFactory.getLogger(receiverClass);
            this.reqLogMsg = String.format("Delivering request object to %s:", receiverClass.getName());
            this.resLogMsg = "Returning response object:";
        }

        public void logRequest(Object msgObj) {
            this.logObject(this.l, this.reqLogMsg, msgObj);
        }

        public void logResponse(Object msgObj) {
            this.logObject(this.l, this.resLogMsg, msgObj);
        }

        private void logObject(Logger l, String msg, Object msgObj) {
            try {
                if (l.isTraceEnabled()) {
                    WSMarshaller m = WSMarshallerFactory.createInstance();
                    String msgObjStr = m.doc2str(m.marshal(msgObj));
                    l.trace("{}\n{}", (Object)msg, (Object)msgObjStr);
                } else if (logger.isTraceEnabled()) {
                    WSMarshaller m = WSMarshallerFactory.createInstance();
                    String msgObjStr = m.doc2str(m.marshal(msgObj));
                    logger.trace("{}\n{}", (Object)msg, (Object)msgObjStr);
                }
            }
            catch (TransformerException | WSMarshallerException ex) {
                logger.error("Failed to log message.", ex);
            }
        }
    }
}

