/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.transport.dispatcher;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.RequestType;
import iso.std.iso_iec._24727.tech.schema.ResponseType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openecard.common.event.ApiCallEventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.Dispatchable;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.interfaces.DispatcherException;
import org.openecard.common.interfaces.DispatcherExceptionUnchecked;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.interfaces.InvocationTargetExceptionUnchecked;
import org.openecard.common.util.HandlerUtils;
import org.openecard.transport.dispatcher.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements Dispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDispatcher.class);
    private final Environment environment;
    private final TreeMap<String, Service> serviceMap;
    private final TreeMap<String, Method> serviceInstMap;
    private final List<String> availableServiceNames;
    private final boolean isFilter;

    public MessageDispatcher(Environment environment) {
        this.environment = environment;
        this.isFilter = false;
        this.serviceMap = new TreeMap();
        this.serviceInstMap = new TreeMap();
        this.initDefinitions();
        this.availableServiceNames = new ArrayList<String>();
        this.createServiceList();
    }

    private MessageDispatcher(Environment environment, boolean isFilter) {
        this.environment = environment;
        this.isFilter = isFilter;
        this.serviceMap = new TreeMap();
        this.serviceInstMap = new TreeMap();
        this.initDefinitions();
        this.availableServiceNames = new ArrayList<String>();
        this.createServiceList();
    }

    @Override
    public Object deliver(Object req) throws DispatcherException, InvocationTargetException {
        EventDispatcher disp = this.environment.getEventDispatcher();
        ConnectionHandleType handle = HandlerUtils.extractHandle(req);
        if (disp != null && req instanceof RequestType) {
            ApiCallEventObject startEvt = new ApiCallEventObject(handle, (RequestType)req);
            LOG.debug("Sending API_CALL_STARTED event.");
            disp.notify(EventType.API_CALL_STARTED, startEvt);
        }
        try {
            Class<?> reqClass = req.getClass();
            Service s = this.getService(reqClass);
            Object serviceImpl = this.getServiceImpl(s);
            LOG.debug("Delivering message of type: {}", (Object)req.getClass().getName());
            Object result = s.invoke(serviceImpl, req);
            if (disp != null && req instanceof RequestType && result instanceof ResponseType) {
                ApiCallEventObject<RequestType, ResponseType> finEvt = new ApiCallEventObject<RequestType, ResponseType>(handle, (RequestType)req);
                finEvt.setResponse((ResponseType)result);
                LOG.debug("Sending API_CALL_FINISHED event.");
                disp.notify(EventType.API_CALL_FINISHED, finEvt);
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new DispatcherException(ex);
        }
    }

    @Override
    public Object safeDeliver(Object request) throws DispatcherExceptionUnchecked, InvocationTargetExceptionUnchecked {
        try {
            return this.deliver(request);
        }
        catch (DispatcherException ex) {
            throw new DispatcherExceptionUnchecked(ex.getMessage(), ex.getCause());
        }
        catch (InvocationTargetException ex) {
            throw new InvocationTargetExceptionUnchecked(ex.getMessage(), ex.getCause());
        }
    }

    private Service getService(Class<?> reqClass) throws IllegalAccessException {
        if (!this.serviceMap.containsKey(reqClass.getName())) {
            String msg = "No service with a method containing parameter type " + reqClass.getName() + " present.";
            throw new IllegalAccessException(msg);
        }
        return this.serviceMap.get(reqClass.getName());
    }

    private Object getServiceImpl(Service s) throws IllegalAccessException, InvocationTargetException {
        Method m = this.serviceInstMap.get(s.getServiceInterface().getName());
        if (m == null) {
            String msg = "The environment does not contain a service for class " + s.getServiceInterface().getName();
            throw new IllegalAccessException(msg);
        }
        Object impl = m.invoke((Object)this.environment, new Object[0]);
        return impl;
    }

    private void initDefinitions() {
        Method[] envMethods;
        Class<?> envClass = this.environment.getClass();
        for (Method nextAccessor : envMethods = envClass.getMethods()) {
            Class<?> returnTypeImpl;
            Class<?> returnType;
            block6: {
                int modifier;
                if (nextAccessor.getAnnotation(Dispatchable.class) == null || Modifier.isAbstract(modifier = nextAccessor.getModifiers()) || !Modifier.isPublic(modifier) || Modifier.isStatic(modifier)) continue;
                Dispatchable methodAnnotation = nextAccessor.getAnnotation(Dispatchable.class);
                returnType = methodAnnotation.interfaceClass();
                if (this.serviceInstMap.containsKey(returnType.getName())) {
                    String msg = "Omitting service type {}, because its type already associated with another service.";
                    LOG.warn(msg, (Object)returnType.getName());
                    continue;
                }
                this.serviceInstMap.put(returnType.getName(), nextAccessor);
                returnTypeImpl = returnType;
                try {
                    Object result = nextAccessor.invoke((Object)this.environment, new Object[0]);
                    if (result == null) break block6;
                    returnTypeImpl = result.getClass();
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    LOG.error("Actual type could not be retrieved from method " + nextAccessor + ".", ex);
                    continue;
                }
            }
            Service service = new Service(returnType, returnTypeImpl, this.isFilter);
            for (Class<?> reqClass : service.getRequestClasses()) {
                if (this.serviceMap.containsKey(reqClass.getName())) {
                    String msg = "Omitting method with parameter type {} in service interface {} because its ";
                    msg = msg + "type already associated with another service.";
                    LOG.warn(msg, (Object)reqClass.getName(), (Object)returnType.getName());
                    continue;
                }
                this.serviceMap.put(reqClass.getName(), service);
            }
        }
    }

    @Override
    public List<String> getServiceList() {
        return Collections.unmodifiableList(this.availableServiceNames);
    }

    @Override
    public Dispatcher getFilter() {
        if (this.isFilter) {
            return this;
        }
        return new MessageDispatcher(this.environment, true);
    }

    private void createServiceList() {
        TreeSet<Service> services = new TreeSet<Service>();
        services.addAll(this.serviceMap.values());
        for (Service service : services) {
            this.availableServiceNames.addAll(service.getActionList());
        }
    }
}

