/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.scio;

import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardNotPresentException;
import javax.smartcardio.CardTerminal;
import org.openecard.common.ifd.scio.SCIOCard;
import org.openecard.common.ifd.scio.SCIOErrorCode;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOProtocol;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.scio.PCSCCard;
import org.openecard.scio.PCSCExceptionExtractor;

public class PCSCTerminal
implements SCIOTerminal {
    private final CardTerminal terminal;

    PCSCTerminal(CardTerminal terminal) {
        this.terminal = terminal;
    }

    @Override
    public String getName() {
        return this.terminal.getName();
    }

    @Override
    public SCIOCard connect(SCIOProtocol protocol) throws SCIOException, IllegalStateException {
        Class<CardTerminal> clazz = CardTerminal.class;
        synchronized (CardTerminal.class) {
            try {
                Card c = this.terminal.connect(protocol.identifier);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return new PCSCCard(this, c);
            }
            catch (CardNotPresentException ex) {
                String msg = "Card has been removed before connect could be finished for terminal '%s'.";
                throw new SCIOException(String.format(msg, this.getName()), SCIOErrorCode.SCARD_W_REMOVED_CARD);
            }
            catch (CardException ex) {
                String msg = "Failed to connect the card in terminal '%s'.";
                throw new SCIOException(String.format(msg, this.getName()), PCSCExceptionExtractor.getCode(ex), ex);
            }
            catch (IllegalArgumentException ex) {
                String msg = String.format("Protocol %s is not accepted by PCSC stack.", protocol.identifier);
                throw new SCIOException(msg, SCIOErrorCode.SCARD_E_PROTO_MISMATCH, ex);
            }
        }
    }

    @Override
    public boolean isCardPresent() throws SCIOException {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException ex) {
            throw new SCIOException("Failed to determine whether card is present or not.", PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws SCIOException {
        try {
            return this.terminal.waitForCardPresent(timeout);
        }
        catch (CardException ex) {
            String msg = "Failed to wait for card present event in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws SCIOException {
        try {
            return this.terminal.waitForCardAbsent(timeout);
        }
        catch (CardException ex) {
            String msg = "Failed to wait for card absent event in terminal '%s'.";
            throw new SCIOException(String.format(msg, this.getName()), PCSCExceptionExtractor.getCode(ex), ex);
        }
    }
}

