/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.genericcryptography;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.io.ByteArrayInputStream;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.exception.InvalidSignatureException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifySignatureStep
implements ProtocolStep<VerifySignature, VerifySignatureResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(VerifySignatureStep.class);
    private final Dispatcher dispatcher;

    public VerifySignatureStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.VerifySignature;
    }

    @Override
    public VerifySignatureResponse perform(VerifySignature request, Map<String, Object> internalData) {
        VerifySignatureResponse response = (VerifySignatureResponse)WSHelper.makeResponse(VerifySignatureResponse.class, WSHelper.makeResultOK());
        try {
            Signature signatureAlgorithm;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            String didName = SALUtils.getDIDName(request);
            DIDStructureType didStructure = SALUtils.getDIDStructure(request, didName, cardStateEntry, connectionHandle);
            byte[] signature = request.getSignature();
            byte[] message = request.getMessage();
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didStructure.getDIDMarker());
            String dataSetNameCertificate = cryptoMarker.getCertificateRefs().get(0).getDataSetName();
            String algorithmIdentifier = cryptoMarker.getAlgorithmInfo().getAlgorithmIdentifier().getAlgorithm();
            DSIRead dsiRead = new DSIRead();
            dsiRead.setConnectionHandle(connectionHandle);
            dsiRead.setDSIName(dataSetNameCertificate);
            DSIReadResponse dsiReadResponse = (DSIReadResponse)this.dispatcher.safeDeliver(dsiRead);
            WSHelper.checkResult(dsiReadResponse);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(dsiReadResponse.getDSIContent()));
            if (algorithmIdentifier.equals("http://ws.openecard.org/alg/rsa")) {
                signatureAlgorithm = Signature.getInstance("RSA", new BouncyCastleProvider());
            } else if (algorithmIdentifier.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256")) {
                signatureAlgorithm = Signature.getInstance("RAWRSASSA-PSS", new BouncyCastleProvider());
                signatureAlgorithm.setParameter(new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
            } else {
                if (algorithmIdentifier.equals("urn:oid:1.3.36.3.4.2")) {
                    return (VerifySignatureResponse)WSHelper.makeResponse(VerifySignatureResponse.class, WSHelper.makeResultUnknownError(algorithmIdentifier + " Not supported yet."));
                }
                if (algorithmIdentifier.equals("urn:oid:1.3.36.3.4.2.3")) {
                    return (VerifySignatureResponse)WSHelper.makeResponse(VerifySignatureResponse.class, WSHelper.makeResultUnknownError(algorithmIdentifier + " Not supported yet."));
                }
                throw new IncorrectParameterException("Unknown signature algorithm.");
            }
            signatureAlgorithm.initVerify(cert);
            if (message != null) {
                signatureAlgorithm.update(message);
            }
            if (!signatureAlgorithm.verify(signature)) {
                throw new InvalidSignatureException();
            }
        }
        catch (ECardException e) {
            LOG.error(e.getMessage(), e);
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }
}

