/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.genericcryptography;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.CryptographicServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Map;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.ProtocolStep;
import org.openecard.common.ECardException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.ManageSecurityEnvironment;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.tlv.TLV;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.openecard.sal.protocol.genericcryptography.apdu.PSODecipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecipherStep
implements ProtocolStep<Decipher, DecipherResponse> {
    private static final Logger logger = LoggerFactory.getLogger(DecipherStep.class);
    private static final byte PADDING_INDICATOR_BYTE = 0;
    private final Dispatcher dispatcher;

    public DecipherStep(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.Decipher;
    }

    @Override
    public DecipherResponse perform(Decipher request, Map<String, Object> internalData) {
        DecipherResponse response = (DecipherResponse)WSHelper.makeResponse(DecipherResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            String didName = SALUtils.getDIDName(request);
            byte[] applicationID = connectionHandle.getCardApplication();
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(internalData, connectionHandle);
            Assert.securityConditionDID(cardStateEntry, applicationID, didName, CryptographicServiceActionName.DECIPHER);
            DIDStructureType didStructure = SALUtils.getDIDStructure(request, didName, cardStateEntry, connectionHandle);
            CryptoMarkerType cryptoMarker = new CryptoMarkerType(didStructure.getDIDMarker());
            byte[] keyReference = cryptoMarker.getCryptoKeyInfo().getKeyRef().getKeyRef();
            byte[] algorithmIdentifier = cryptoMarker.getAlgorithmInfo().getCardAlgRef();
            byte[] slotHandle = connectionHandle.getSlotHandle();
            if (didStructure.getDIDScope().equals((Object)DIDScopeType.LOCAL)) {
                keyReference[0] = (byte)(0x80 | keyReference[0]);
            }
            TLV tagKeyReference = new TLV();
            tagKeyReference.setTagNumWithClass(132L);
            tagKeyReference.setValue(keyReference);
            TLV tagAlgorithmIdentifier = new TLV();
            tagAlgorithmIdentifier.setTagNumWithClass(128L);
            tagAlgorithmIdentifier.setValue(algorithmIdentifier);
            byte[] mseData = ByteUtils.concatenate(tagKeyReference.toBER(), tagAlgorithmIdentifier.toBER());
            CardCommandAPDU apdu = new ManageSecurityEnvironment(65, -72, mseData);
            apdu.transmit(this.dispatcher, slotHandle);
            byte[] ciphertext = request.getCipherText();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BigInteger bitKeySize = cryptoMarker.getCryptoKeyInfo().getKeySize();
            int blocksize = bitKeySize.divide(new BigInteger("8")).intValue();
            if (ciphertext.length % blocksize != 0) {
                return (DecipherResponse)WSHelper.makeResponse(DecipherResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", "The length of the ciphertext should be a multiple of the blocksize."));
            }
            for (int offset = 0; offset < ciphertext.length; offset += blocksize) {
                byte[] ciphertextblock = ByteUtils.copy(ciphertext, offset, blocksize);
                apdu = new PSODecipher(ByteUtils.concatenate((byte)0, ciphertextblock), (byte)blocksize);
                CardResponseAPDU responseAPDU = apdu.transmit(this.dispatcher, slotHandle);
                baos.write(responseAPDU.getData());
            }
            response.setPlainText(baos.toByteArray());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }
}

