/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openecard.common.DynamicContext;
import org.openecard.common.util.Promise;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.Step;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingStepAction
extends StepAction {
    private static final Logger logger = LoggerFactory.getLogger(ProcessingStepAction.class);
    private final DynamicContext ctx;
    private final Promise<Object> p = new Promise();

    public ProcessingStepAction(Step step) {
        super(step);
        this.ctx = DynamicContext.getInstance("tr03112");
        this.ctx.putPromise("processing_canceled", this.p);
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        if (result.isCancelled()) {
            this.p.deliver(true);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        Promise<Object> pAuthDone = this.ctx.getPromise("org.openecard.tr03112.eac.authentication_done");
        try {
            pAuthDone.deref(120L, TimeUnit.SECONDS);
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        catch (InterruptedException ex) {
            logger.error("ProcessingStepAction interrupted by the user or an other thread.", ex);
            this.p.deliver(true);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
        catch (TimeoutException ex) {
            logger.info("Timeout while waiting for the authentication to finish.", ex);
            return new StepActionResult(StepActionResultStatus.CANCEL);
        }
    }
}

