/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.EstablishChannel;
import iso.std.iso_iec._24727.tech.schema.EstablishChannelResponse;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteUtils;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.sal.protocol.eac.EACData;
import org.openecard.sal.protocol.eac.anytype.PasswordID;
import org.openecard.sal.protocol.eac.gui.ErrorStep;
import org.openecard.sal.protocol.eac.gui.PINStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PINStepAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(PINStepAction.class);
    private static final byte[] DEAKTIVATED = new byte[]{98, -125};
    private static final byte[] RC3 = new byte[]{-112, 0};
    private static final byte[] RC1 = new byte[]{99, -63};
    private static final byte[] RC2 = new byte[]{99, -62};
    private static final String PIN_ID_CAN = "2";
    private static final String ERROR_CARD_REMOVED = "action.error.card.removed";
    private static final String ERROR_INTERNAL = "action.error.internal";
    private static final String ERROR_TITLE = "action.error.title";
    private static final String ERROR_UNKNOWN = "action.error.unknown";
    private final String pin;
    private final String puk;
    private final EACData eacData;
    private final boolean capturePin;
    private final byte[] slotHandle;
    private final Dispatcher dispatcher;
    private final PINStep step;
    private final I18n lang = I18n.getTranslation("pace");
    private final I18n langPin = I18n.getTranslation("pinplugin");
    private final DynamicContext ctx;
    private int retryCounter;

    public PINStepAction(EACData eacData, boolean capturePin, byte[] slotHandle, Dispatcher dispatcher, PINStep step, byte[] status) {
        super(step);
        this.eacData = eacData;
        this.capturePin = capturePin;
        this.slotHandle = slotHandle;
        this.dispatcher = dispatcher;
        this.step = step;
        this.ctx = DynamicContext.getInstance("tr03112");
        if (Arrays.equals(status, RC3)) {
            this.retryCounter = 0;
        } else if (Arrays.equals(status, RC2)) {
            this.retryCounter = 1;
            step.updateAttemptsDisplay(2);
        } else if (Arrays.equals(status, RC1)) {
            this.retryCounter = 2;
            step.updateAttemptsDisplay(1);
            if (capturePin) {
                step.addCANEntry();
            } else {
                step.addNativeCANNotice();
            }
        } else if (Arrays.equals(status, DEAKTIVATED)) {
            this.retryCounter = -1;
        }
        this.pin = this.lang.translationForKey("pin", new Object[0]);
        this.puk = this.lang.translationForKey("puk", new Object[0]);
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        block18: {
            if (result.isBack()) {
                return new StepActionResult(StepActionResultStatus.BACK);
            }
            if (this.retryCounter == 2) {
                try {
                    EstablishChannelResponse response = this.performPACEWithCAN(oldResults);
                    if (response == null) {
                        LOG.debug("The CAN does not meet the format requirements.");
                        return new StepActionResult(StepActionResultStatus.REPEAT);
                    }
                    if (response.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                        if (response.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed")) {
                            LOG.error("Failed to authenticate with the given CAN.");
                            return new StepActionResult(StepActionResultStatus.REPEAT);
                        }
                        WSHelper.checkResult(response);
                    }
                }
                catch (WSHelper.WSException ex) {
                    if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser")) {
                        LOG.error("User canceled the authentication manually.", ex);
                        this.ctx.put("org.openecard.tr03112.eac.pace_successful", ex);
                        return new StepActionResult(StepActionResultStatus.CANCEL);
                    }
                    if (!ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle")) break block18;
                    LOG.error("The SlotHandle was invalid so probably the user removed the card or an reset occurred.", ex);
                    this.ctx.put("org.openecard.tr03112.eac.pace_successful", ex);
                    return new StepActionResult(StepActionResultStatus.REPEAT, new ErrorStep(this.lang.translationForKey(ERROR_TITLE, new Object[0]), this.langPin.translationForKey(ERROR_CARD_REMOVED, new Object[0])));
                }
            }
        }
        try {
            EstablishChannelResponse establishChannelResponse = this.performPACEWithPIN(oldResults);
            if (establishChannelResponse.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                if (establishChannelResponse.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordError")) {
                    ++this.retryCounter;
                    this.step.updateAttemptsDisplay(3 - this.retryCounter);
                    LOG.info("Wrong PIN entered, trying again (try number {}).", (Object)this.retryCounter);
                    return new StepActionResult(StepActionResultStatus.REPEAT);
                }
                if (establishChannelResponse.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordSuspended")) {
                    ++this.retryCounter;
                    this.step.updateAttemptsDisplay(3 - this.retryCounter);
                    LOG.info("Wrong PIN entered, trying again (try number {}).", (Object)this.retryCounter);
                    if (this.capturePin) {
                        this.step.addCANEntry();
                    } else {
                        this.step.addNativeCANNotice();
                    }
                    return new StepActionResult(StepActionResultStatus.REPEAT);
                }
                if (establishChannelResponse.getResult().getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/passwordBlocked")) {
                    LOG.warn("Wrong PIN entered. The PIN is blocked.");
                    this.ctx.put("org.openecard.tr03112.eac.pace_successful", WSHelper.createException(establishChannelResponse.getResult()));
                    return new StepActionResult(StepActionResultStatus.REPEAT, new ErrorStep(this.lang.translationForKey("step_error_title_blocked", this.pin), this.lang.translationForKey("step_error_pin_blocked", this.pin, this.pin, this.puk, this.pin)));
                }
                WSHelper.checkResult(establishChannelResponse);
            }
            this.eacData.paceResponse = establishChannelResponse;
            this.ctx.put("org.openecard.tr03112.eac.pace_successful", null);
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        catch (WSHelper.WSException ex) {
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser")) {
                LOG.error("User canceled the authentication manually.", ex);
                this.ctx.put("org.openecard.tr03112.eac.pace_successful", ex);
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
            if (ex.getResultMinor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#invalidSlotHandle")) {
                LOG.error("The SlotHandle was invalid so probably the user removed the card or an reset occurred.", ex);
                this.ctx.put("org.openecard.tr03112.eac.pace_successful", ex);
                return new StepActionResult(StepActionResultStatus.REPEAT, new ErrorStep(this.lang.translationForKey(ERROR_TITLE, new Object[0]), this.langPin.translationForKey(ERROR_CARD_REMOVED, new Object[0])));
            }
            LOG.error("An unknown error occured while trying to verify the PIN.");
            this.ctx.put("org.openecard.tr03112.eac.pace_successful", ex);
            return new StepActionResult(StepActionResultStatus.REPEAT, new ErrorStep(this.langPin.translationForKey(ERROR_TITLE, new Object[0]), this.langPin.translationForKey(ERROR_UNKNOWN, new Object[0])));
        }
    }

    private EstablishChannelResponse performPACEWithPIN(Map<String, ExecutionResults> oldResults) {
        AuthDataMap paceAuthMap;
        DIDAuthenticationDataType protoData = this.eacData.didRequest.getAuthenticationProtocolData();
        try {
            paceAuthMap = new AuthDataMap(protoData);
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Failed to read EAC Protocol data.", ex);
            return null;
        }
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = paceAuthMap.createResponse(protoData);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField p = (PasswordField)executionResults.getResult("PACE_PIN_FIELD");
            char[] pinIn = p.getValue();
            if (pinIn.length == 0) {
                return null;
            }
            paceInputMap.addElement("PIN", new String(pinIn));
        }
        paceInputMap.addElement("PinID", PasswordID.parse(this.eacData.pinID).getByteAsString());
        paceInputMap.addElement("CHAT", this.eacData.selectedCHAT.toString());
        String certDesc = ByteUtils.toHexString(this.eacData.rawCertificateDescription);
        paceInputMap.addElement("CertificateDescription", certDesc);
        EstablishChannel eChannel = this.createEstablishChannelStructure(paceInputMap);
        return (EstablishChannelResponse)this.dispatcher.safeDeliver(eChannel);
    }

    private EstablishChannelResponse performPACEWithCAN(Map<String, ExecutionResults> oldResults) {
        AuthDataMap tmp;
        DIDAuthenticationDataType paceInput = new DIDAuthenticationDataType();
        paceInput.setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        try {
            tmp = new AuthDataMap(paceInput);
        }
        catch (ParserConfigurationException ex) {
            LOG.error("Failed to read empty Protocol data.", ex);
            return null;
        }
        AuthDataResponse<DIDAuthenticationDataType> paceInputMap = tmp.createResponse(paceInput);
        if (this.capturePin) {
            ExecutionResults executionResults = oldResults.get(this.getStepID());
            PasswordField canField = (PasswordField)executionResults.getResult("PACE_CAN_FIELD");
            String canValue = new String(canField.getValue());
            if (canValue.length() != 6) {
                return null;
            }
            paceInputMap.addElement("PIN", canValue);
        }
        paceInputMap.addElement("PinID", PIN_ID_CAN);
        EstablishChannel eChannel = this.createEstablishChannelStructure(paceInputMap);
        return (EstablishChannelResponse)this.dispatcher.safeDeliver(eChannel);
    }

    private EstablishChannel createEstablishChannelStructure(AuthDataResponse paceInputMap) {
        EstablishChannel establishChannel = new EstablishChannel();
        establishChannel.setSlotHandle(this.slotHandle);
        establishChannel.setAuthenticationProtocolData((DIDAuthenticationDataType)paceInputMap.getResponse());
        establishChannel.getAuthenticationProtocolData().setProtocol("urn:oid:0.4.0.127.0.7.2.2.4");
        return establishChannel;
    }
}

