/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.gui;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardRemovedFilter
implements EventFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CardRemovedFilter.class);
    private final String ifdName;
    private final BigInteger slotIdx;

    public CardRemovedFilter(@Nonnull String ifdName, @Nonnull BigInteger slotIdx) {
        this.ifdName = ifdName;
        this.slotIdx = slotIdx;
    }

    @Override
    public boolean matches(EventType t, Object o) {
        LOG.debug("Received event.");
        if (t.equals((Object)EventType.CARD_REMOVED)) {
            LOG.debug("Received CARD_REMOVED event.");
            ConnectionHandleType conHandle = (ConnectionHandleType)o;
            if (this.ifdName.equals(conHandle.getIFDName()) && this.slotIdx.equals(conHandle.getSlotIndex())) {
                LOG.info("Card removed during processing of EAC GUI.");
                return true;
            }
            LOG.debug("An unrelated card has been removed.");
            return false;
        }
        return false;
    }
}

